/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.auth;

import com.github.cassandra.jdbc.internal.cassandra.auth.AuthenticatedUser;
import com.github.cassandra.jdbc.internal.cassandra.auth.IResource;
import com.github.cassandra.jdbc.internal.cassandra.auth.RoleOptions;
import com.github.cassandra.jdbc.internal.cassandra.auth.RoleResource;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.ConfigurationException;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.RequestExecutionException;
import com.github.cassandra.jdbc.internal.cassandra.exceptions.RequestValidationException;
import java.util.Map;
import java.util.Set;

public interface IRoleManager {
    public Set<Option> supportedOptions();

    public Set<Option> alterableOptions();

    public void createRole(AuthenticatedUser var1, RoleResource var2, RoleOptions var3) throws RequestValidationException, RequestExecutionException;

    public void dropRole(AuthenticatedUser var1, RoleResource var2) throws RequestValidationException, RequestExecutionException;

    public void alterRole(AuthenticatedUser var1, RoleResource var2, RoleOptions var3) throws RequestValidationException, RequestExecutionException;

    public void grantRole(AuthenticatedUser var1, RoleResource var2, RoleResource var3) throws RequestValidationException, RequestExecutionException;

    public void revokeRole(AuthenticatedUser var1, RoleResource var2, RoleResource var3) throws RequestValidationException, RequestExecutionException;

    public Set<RoleResource> getRoles(RoleResource var1, boolean var2) throws RequestValidationException, RequestExecutionException;

    public Set<RoleResource> getAllRoles() throws RequestValidationException, RequestExecutionException;

    public boolean isSuper(RoleResource var1);

    public boolean canLogin(RoleResource var1);

    public Map<String, String> getCustomOptions(RoleResource var1);

    public boolean isExistingRole(RoleResource var1);

    public Set<? extends IResource> protectedResources();

    public void validateConfiguration() throws ConfigurationException;

    public void setup();

    public static enum Option {
        SUPERUSER,
        PASSWORD,
        LOGIN,
        OPTIONS;

    }
}

