/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.auth;

import com.github.cassandra.jdbc.internal.cassandra.auth.IResource;
import com.github.cassandra.jdbc.internal.cassandra.auth.Permission;
import com.github.cassandra.jdbc.internal.cassandra.auth.PermissionsCache;
import com.github.cassandra.jdbc.internal.cassandra.auth.RoleResource;
import com.github.cassandra.jdbc.internal.cassandra.auth.Roles;
import com.github.cassandra.jdbc.internal.cassandra.config.DatabaseDescriptor;
import com.github.cassandra.jdbc.internal.google.common.base.Objects;
import java.util.Set;

public class AuthenticatedUser {
    public static final String SYSTEM_USERNAME = "system";
    public static final AuthenticatedUser SYSTEM_USER = new AuthenticatedUser("system");
    public static final String ANONYMOUS_USERNAME = "anonymous";
    public static final AuthenticatedUser ANONYMOUS_USER = new AuthenticatedUser("anonymous");
    private static final PermissionsCache permissionsCache = new PermissionsCache(DatabaseDescriptor.getAuthorizer());
    private final String name;
    private final RoleResource role;

    public AuthenticatedUser(String name) {
        this.name = name;
        this.role = RoleResource.role(name);
    }

    public String getName() {
        return this.name;
    }

    public RoleResource getPrimaryRole() {
        return this.role;
    }

    public boolean isSuper() {
        return !this.isAnonymous() && Roles.hasSuperuserStatus(this.role);
    }

    public boolean isAnonymous() {
        return this == ANONYMOUS_USER;
    }

    public boolean isSystem() {
        return this == SYSTEM_USER;
    }

    public Set<RoleResource> getRoles() {
        return Roles.getRoles(this.role);
    }

    public Set<Permission> getPermissions(IResource resource) {
        return permissionsCache.getPermissions(this, resource);
    }

    public String toString() {
        return String.format("#<User %s>", this.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AuthenticatedUser)) {
            return false;
        }
        AuthenticatedUser u = (AuthenticatedUser)o;
        return Objects.equal(this.name, u.name);
    }

    public int hashCode() {
        return Objects.hashCode(this.name);
    }
}

