/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.auth;

import com.github.cassandra.jdbc.internal.cassandra.auth.DataResource;
import com.github.cassandra.jdbc.internal.cassandra.auth.FunctionResource;
import com.github.cassandra.jdbc.internal.cassandra.config.DatabaseDescriptor;
import com.github.cassandra.jdbc.internal.cassandra.db.marshal.AbstractType;
import com.github.cassandra.jdbc.internal.cassandra.service.MigrationListener;
import java.util.List;

public class AuthMigrationListener
extends MigrationListener {
    public void onDropKeyspace(String ksName) {
        DatabaseDescriptor.getAuthorizer().revokeAllOn(DataResource.keyspace(ksName));
        DatabaseDescriptor.getAuthorizer().revokeAllOn(FunctionResource.keyspace(ksName));
    }

    public void onDropColumnFamily(String ksName, String cfName) {
        DatabaseDescriptor.getAuthorizer().revokeAllOn(DataResource.table(ksName, cfName));
    }

    public void onDropFunction(String ksName, String functionName, List<AbstractType<?>> argTypes) {
        DatabaseDescriptor.getAuthorizer().revokeAllOn(FunctionResource.function(ksName, functionName, argTypes));
    }
}

