/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.internal.cassandra.auth;

import com.github.cassandra.jdbc.internal.cassandra.config.CFMetaData;
import com.github.cassandra.jdbc.internal.cassandra.schema.KeyspaceMetadata;
import com.github.cassandra.jdbc.internal.cassandra.schema.KeyspaceParams;
import com.github.cassandra.jdbc.internal.cassandra.schema.Tables;
import java.util.concurrent.TimeUnit;

public final class AuthKeyspace {
    public static final String NAME = "system_auth";
    public static final String ROLES = "roles";
    public static final String ROLE_MEMBERS = "role_members";
    public static final String ROLE_PERMISSIONS = "role_permissions";
    public static final String RESOURCE_ROLE_INDEX = "resource_role_permissons_index";
    public static final long SUPERUSER_SETUP_DELAY = Long.getLong("cassandra.superuser_setup_delay_ms", 10000L);
    private static final CFMetaData Roles = AuthKeyspace.compile("roles", "role definitions", "CREATE TABLE %s (role text,is_superuser boolean,can_login boolean,salted_hash text,member_of set<text>,PRIMARY KEY(role))");
    private static final CFMetaData RoleMembers = AuthKeyspace.compile("role_members", "role memberships lookup table", "CREATE TABLE %s (role text,member text,PRIMARY KEY(role, member))");
    private static final CFMetaData RolePermissions = AuthKeyspace.compile("role_permissions", "permissions granted to db roles", "CREATE TABLE %s (role text,resource text,permissions set<text>,PRIMARY KEY(role, resource))");
    private static final CFMetaData ResourceRoleIndex = AuthKeyspace.compile("resource_role_permissons_index", "index of db roles with permissions granted on a resource", "CREATE TABLE %s (resource text,role text,PRIMARY KEY(resource, role))");

    private AuthKeyspace() {
    }

    private static CFMetaData compile(String name, String description, String schema) {
        return CFMetaData.compile(String.format(schema, name), NAME).comment(description).gcGraceSeconds((int)TimeUnit.DAYS.toSeconds(90L));
    }

    public static KeyspaceMetadata metadata() {
        return KeyspaceMetadata.create((String)NAME, (KeyspaceParams)KeyspaceParams.simple((int)1), (Tables)Tables.of((CFMetaData[])new CFMetaData[]{Roles, RoleMembers, RolePermissions, ResourceRoleIndex}));
    }
}

