/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc.cql;

import com.github.cassandra.jdbc.CassandraCqlStmtConfiguration;
import com.github.cassandra.jdbc.internal.cassandra.cql3.selection.RawSelector;
import com.github.cassandra.jdbc.internal.cassandra.cql3.statements.SelectStatement;

public class CqlSelectFormatter {
    public String format(CassandraCqlStmtConfiguration stmtConfig, SelectStatement.RawStatement select) {
        StringBuilder builder = new StringBuilder("SELECT ");
        if (select.selectClause.size() == 0) {
            builder.append("* ");
        } else {
            for (RawSelector selector : select.selectClause) {
                builder.append(selector.alias.toCQLString()).append(", ");
            }
        }
        builder.append("FROM ").append(select.columnFamily());
        if (select.whereClause.expressions.size() > 0 || select.whereClause.relations.size() > 0) {
            builder.append("WHERE ");
            if (select.parameters.allowFiltering) {
                builder.append("ALLOW FILTERING");
            }
        }
        return builder.toString();
    }
}

