/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc;

import com.github.cassandra.jdbc.BaseCassandraResultSet;
import com.github.cassandra.jdbc.CassandraColumnDefinition;
import com.github.cassandra.jdbc.CassandraErrors;
import com.github.cassandra.jdbc.internal.tinylog.Level;
import com.github.cassandra.jdbc.internal.tinylog.Logger;
import java.sql.SQLException;
import java.util.Arrays;

public class DummyCassandraResultSet
extends BaseCassandraResultSet {
    private static final Level LOG_LEVEL = Logger.getLevel(DummyCassandraResultSet.class);
    private Object[] currentRow;
    private final Object[][] data;

    public DummyCassandraResultSet() {
        this(new String[0][], (Object[][])null);
    }

    public DummyCassandraResultSet(String[][] columns, Object[][] data) {
        super(null, null);
        Logger.trace("Constructing dummy result set @{}...", this.hashCode());
        if (columns != null && columns.length > 0 && columns[0].length > 1) {
            for (String[] column : columns) {
                Logger.trace("* Column: {name={}, cqlType={}}", column[0], column[1]);
                this.metadata.addColumnDefinition(new CassandraColumnDefinition(null, null, column[0], column[1], false));
            }
        }
        Object object = this.data = data == null ? new String[][]{} : data;
        if (LOG_LEVEL.compareTo(Level.TRACE) >= 0) {
            for (Object[] row : this.data) {
                Logger.trace("* Row: {}", Arrays.toString(row));
            }
        }
        Logger.trace("Dummy result set @{} is ready for use", this.hashCode());
    }

    @Override
    protected <T> T getValue(int columnIndex, Class<T> clazz) throws SQLException {
        Logger.trace("Trying to get value with inputs: line={}, column={}, type={}", this.getRow(), columnIndex, clazz);
        Object obj = this.currentRow[columnIndex - 1];
        T result = null;
        Logger.trace("Got raw value [{}] from line {} of {}", obj, this.getRow(), this.data.length);
        this.wasNull = obj == null;
        result = this.getDataTypeConverters().convert(obj, clazz, false);
        Logger.trace("Return value: raw={}, converted={}", obj, result);
        return result;
    }

    @Override
    protected boolean hasMore() {
        return this.getCurrentRowIndex() < this.data.length;
    }

    @Override
    protected <T> void setValue(int columnIndex, T value) throws SQLException {
        throw CassandraErrors.notSupportedException();
    }

    @Override
    protected SQLException tryClose() {
        return null;
    }

    @Override
    protected boolean tryIterate() throws SQLException {
        boolean success;
        int row = this.getCurrentRowIndex();
        boolean bl = success = row < this.data.length;
        if (success) {
            this.currentRow = this.data[row];
        }
        return success;
    }

    @Override
    protected boolean tryMoveTo(int rows, boolean relativeIndex) throws SQLException {
        throw CassandraErrors.notSupportedException();
    }

    @Override
    protected Object unwrap() {
        return this;
    }

    public int getColumnCount() {
        return this.data.length > 0 && this.data[0] != null ? this.data[0].length : 0;
    }

    public int getRowCount() {
        return this.data.length == 0 ? 0 : this.data.length;
    }
}

