/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc;

public enum CassandraStatementType {
    CREATE("DDL", "CREATE"),
    ALTER("DDL", "ALTER"),
    DROP("DDL", "DROP"),
    SELECT("DML", "SELECT"),
    INSERT("DML", "INSERT"),
    UPDATE("DML", "UPDATE"),
    DELETE("DML", "DELETE"),
    TRUNCATE("DML", "TRUNCATE"),
    UNKNOWN("DML", "UNKNOWN");

    private static final String TYPE_QUERY = "SELECT";
    private static final String CATEGORY_DDL = "DDL";
    private static final String CATEGORY_DML = "DML";
    private final String category;
    private final String type;

    private CassandraStatementType(String category, String type) {
        this.category = category;
        this.type = type;
    }

    public String getCategory() {
        return this.category;
    }

    public String getType() {
        return this.type;
    }

    public boolean isQuery() {
        return TYPE_QUERY.equals(this.type);
    }

    public boolean isUpdate() {
        return this.isDML() && !this.isQuery();
    }

    public boolean isDDL() {
        return CATEGORY_DDL.equals(this.category);
    }

    public boolean isDML() {
        return CATEGORY_DML.equals(this.category);
    }
}

