/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc;

import com.github.cassandra.jdbc.BaseJdbcObject;
import com.github.cassandra.jdbc.CassandraColumnDefinition;
import com.github.cassandra.jdbc.internal.tinylog.Logger;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CassandraResultSetMetaData
extends BaseJdbcObject
implements ResultSetMetaData {
    protected final List<CassandraColumnDefinition> columnDefinitions = new ArrayList<CassandraColumnDefinition>();
    protected final Map<String, Integer> columnNameIndices = new HashMap<String, Integer>();

    public CassandraResultSetMetaData() {
        super(true);
    }

    @Override
    protected SQLException tryClose() {
        return null;
    }

    @Override
    protected Object unwrap() {
        return this;
    }

    public void addColumnDefinition(CassandraColumnDefinition def) {
        if (this.columnDefinitions.add(def)) {
            this.columnNameIndices.put(def.getColumnName(), this.columnDefinitions.size() - 1);
        }
    }

    public void clear() {
        this.columnNameIndices.clear();
        this.columnDefinitions.clear();
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return this.getColumnDefinition(column).getCatalogName();
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        return this.getColumnDefinition(column).getColumnClassName();
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.columnDefinitions.size();
    }

    public CassandraColumnDefinition getColumnDefinition(int column) throws SQLException {
        if (column > 0 && column <= this.columnDefinitions.size()) {
            return this.columnDefinitions.get(column - 1);
        }
        Logger.trace("Columns for your reference: " + this.columnNameIndices);
        throw new SQLException("Column " + column + " does not exists!");
    }

    public CassandraColumnDefinition getColumnDefinition(String columnName) throws SQLException {
        int column;
        int n = column = this.columnNameIndices.containsKey(columnName) ? this.columnNameIndices.get(columnName) : -1;
        if (column >= 0 && column < this.columnDefinitions.size()) {
            return this.columnDefinitions.get(column);
        }
        Logger.trace("Columns for your reference: " + this.columnNameIndices);
        throw new SQLException("Column " + columnName + " does not exists!");
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return this.getColumnDefinition(column).getColumnDisplaySize();
    }

    public int getColumnIndex(String columnLabel) throws SQLException {
        if (!this.columnNameIndices.containsKey(columnLabel)) {
            throw new SQLException("Column label \"" + columnLabel + "\" does not exists");
        }
        return this.columnNameIndices.get(columnLabel);
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.getColumnDefinition(column).getColumnLabel();
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.getColumnDefinition(column).getColumnName();
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        return this.getColumnDefinition(column).getColumnType();
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        return this.getColumnDefinition(column).getColumnTypeName();
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return this.getColumnDefinition(column).getPrecision();
    }

    @Override
    public int getScale(int column) throws SQLException {
        return this.getColumnDefinition(column).getScale();
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return this.getColumnDefinition(column).getSchemaName();
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return this.getColumnDefinition(column).getTableName();
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return this.getColumnDefinition(column).isAutoIncrement();
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return this.getColumnDefinition(column).isCaseSensitive();
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return this.getColumnDefinition(column).isCurrency();
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return this.getColumnDefinition(column).isDefinitelyWritable();
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return this.getColumnDefinition(column).isNullable();
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return this.getColumnDefinition(column).isReadOnly();
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return this.getColumnDefinition(column).isSearchable();
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return this.getColumnDefinition(column).isSigned();
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return this.getColumnDefinition(column).isWritable();
    }
}

