/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc;

import com.github.cassandra.jdbc.BaseCassandraConnection;
import com.github.cassandra.jdbc.BaseJdbcObject;
import com.github.cassandra.jdbc.CassandraColumnDefinition;
import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class CassandraParameterMetaData
extends BaseJdbcObject
implements ParameterMetaData {
    private final BaseCassandraConnection _conn;
    private final List<CassandraColumnDefinition> _columns;

    protected CassandraParameterMetaData(BaseCassandraConnection conn) {
        super(conn == null || conn.quiet);
        this._conn = conn;
        this._columns = new ArrayList<CassandraColumnDefinition>();
    }

    @Override
    protected SQLException tryClose() {
        return null;
    }

    @Override
    protected Object unwrap() {
        return this;
    }

    protected CassandraColumnDefinition getParameterDefinition(int index) {
        return this._columns.get(index - 1);
    }

    public void addParameterDefinition(CassandraColumnDefinition def) {
        this._columns.add(def);
    }

    public void clear() {
        this._columns.clear();
    }

    @Override
    public int getParameterCount() throws SQLException {
        return this._columns.size();
    }

    @Override
    public int isNullable(int param) throws SQLException {
        return this.getParameterDefinition(param).isNullable();
    }

    @Override
    public boolean isSigned(int param) throws SQLException {
        return this.getParameterDefinition(param).isSigned();
    }

    @Override
    public int getPrecision(int param) throws SQLException {
        return this.getParameterDefinition(param).getPrecision();
    }

    @Override
    public int getScale(int param) throws SQLException {
        return this.getParameterDefinition(param).getScale();
    }

    @Override
    public int getParameterType(int param) throws SQLException {
        return this.getParameterDefinition(param).getColumnType();
    }

    @Override
    public String getParameterTypeName(int param) throws SQLException {
        return this.getParameterDefinition(param).getColumnTypeName();
    }

    public Class getParameterClass(int param) throws SQLException {
        return this.getParameterDefinition(param).getColumnClass();
    }

    @Override
    public String getParameterClassName(int param) throws SQLException {
        return this.getParameterDefinition(param).getColumnClassName();
    }

    @Override
    public int getParameterMode(int param) throws SQLException {
        this.getParameterDefinition(param);
        return 1;
    }
}

