/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc;

import com.github.cassandra.jdbc.CassandraUtils;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;

public final class CassandraErrors {
    public static final int ERROR_CODE_GENERAL = -1;

    public static SQLException connectionClosedException() {
        return new SQLException(CassandraUtils.getString("EXCEPTION_CONNECTION_CLOSED"), null, -1);
    }

    public static SQLException databaseMetaDataNotAvailableException() {
        return new SQLException(CassandraUtils.getString("EXCEPTION_DATABASE_METADATA_NOT_AVAILABLE"), null, -1);
    }

    public static SQLException failedToChangeKeyspaceException(String keyspace, Exception cause) {
        return new SQLException(CassandraUtils.getString("EXCEPTION_FAILED_TO_CHANGE_KEYSPACE", keyspace), null, -1, cause);
    }

    public static SQLException failedToCloseConnectionException(Exception cause) {
        return new SQLException(CassandraUtils.getString("EXCEPTION_FAILED_TO_CLOSE_CONNECTION"), null, -1, cause);
    }

    public static SQLException failedToCloseResourceException(String resourceName, Throwable cause) {
        return new SQLException(CassandraUtils.getString("EXCEPTION_FAILED_TO_CLOSE_RESOURCE", resourceName), null, -1, cause);
    }

    public static SQLException invalidKeyspaceException(String keyspace) {
        return new SQLException(CassandraUtils.getString("EXCEPTION_INVALID_KEYSPACE", keyspace), null, -1);
    }

    public static SQLException invalidQueryException(String query) {
        return new SQLException(CassandraUtils.getString("EXCEPTION_INVALID_QUERY", query), null, -1);
    }

    public static SQLFeatureNotSupportedException notSupportedException() {
        return new SQLFeatureNotSupportedException(CassandraUtils.getString("EXCEPTION_NOT_SUPPORTED"), null, -1);
    }

    public static SQLException resourceClosedException(Object obj) {
        return new SQLException(CassandraUtils.getString("EXCEPTION_RESOURCE_CLOSED", obj), null, -1);
    }

    public static SQLException resultSetClosed() {
        return new SQLException(CassandraUtils.getString("EXCEPTION_RESULTSET_CLOSED"), null, -1);
    }

    public static SQLException statementClosedException() {
        return new SQLException(CassandraUtils.getString("EXCEPTION_STATEMENT_CLOSED"), null, -1);
    }

    public static IllegalStateException unexpectedException(Throwable cause) {
        return new IllegalStateException(CassandraUtils.getString("EXCEPTION_UNEXPECTED"), cause);
    }
}

