/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc;

import com.github.cassandra.jdbc.BaseCassandraConnection;
import com.github.cassandra.jdbc.CassandraConfiguration;
import com.github.cassandra.jdbc.CassandraErrors;
import com.github.cassandra.jdbc.CassandraUtils;
import com.github.cassandra.jdbc.internal.google.common.collect.Iterables;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

public class CassandraDriver
implements Driver {
    static final String MSG_PREFIX = "MESSAGE_PROP_";
    static final String MSG_SUFFIX = "_DESCRIPTION";
    static final String PROVIDER_PREFIX = CassandraUtils.class.getPackage().getName() + ".provider.";
    static final String PROVIDER_SUFFIX = "CassandraConnection";

    static BaseCassandraConnection createConnection(CassandraConfiguration config) throws SQLException {
        BaseCassandraConnection conn;
        try {
            Class<?> clazz = CassandraUtils.class.getClassLoader().loadClass(new StringBuffer().append(PROVIDER_PREFIX).append(config.getProvider()).append('.').append(PROVIDER_SUFFIX).toString());
            Constructor<?> c = clazz.getConstructor(CassandraConfiguration.class);
            conn = (BaseCassandraConnection)c.newInstance(config);
        }
        catch (Exception e) {
            throw new SQLException(e.getCause() == null ? e : e.getCause());
        }
        return conn;
    }

    private DriverPropertyInfo createDriverPropertyInfo(String propertyName, Object propertyValue) {
        Class propertyClass = propertyValue == null ? Object.class : propertyValue.getClass();
        DriverPropertyInfo info = new DriverPropertyInfo(propertyName, String.valueOf(propertyValue));
        info.required = false;
        info.description = CassandraUtils.getString(MSG_PREFIX + propertyName.toUpperCase() + MSG_SUFFIX);
        if (propertyClass.isEnum()) {
            int len;
            T[] values = propertyClass.getEnumConstants();
            int n = len = values == null ? 0 : values.length;
            if (len > 0) {
                String[] choices = new String[len];
                for (int i = 0; i < len; ++i) {
                    choices[i] = String.valueOf(values[i]);
                }
                info.choices = choices;
            }
        }
        return info;
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return CassandraConfiguration.isValidUrl(url);
    }

    @Override
    public Connection connect(String url, Properties props) throws SQLException {
        if (this.acceptsURL(url)) {
            CassandraConfiguration config = new CassandraConfiguration(url, props);
            return CassandraDriver.createConnection(config);
        }
        return null;
    }

    @Override
    public int getMajorVersion() {
        return CassandraConfiguration.VERSION_MAJOR;
    }

    @Override
    public int getMinorVersion() {
        return CassandraConfiguration.VERSION_MINOR;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw CassandraErrors.notSupportedException();
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties props) throws SQLException {
        ArrayList<DriverPropertyInfo> list = new ArrayList<DriverPropertyInfo>();
        for (Map.Entry<String, Object> entry : CassandraConfiguration.DEFAULT.toSortedMap().entrySet()) {
            String key = entry.getKey();
            list.add(this.createDriverPropertyInfo(key, entry.getValue()));
        }
        return Iterables.toArray(list, DriverPropertyInfo.class);
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    static {
        try {
            CassandraDriver driver = new CassandraDriver();
            DriverManager.registerDriver(driver);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

