/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc;

import com.github.cassandra.jdbc.BaseCassandraConnection;
import com.github.cassandra.jdbc.BaseJdbcObject;
import com.github.cassandra.jdbc.CassandraConfiguration;
import com.github.cassandra.jdbc.CassandraErrors;
import com.github.cassandra.jdbc.CassandraObjectType;
import com.github.cassandra.jdbc.CassandraUtils;
import com.github.cassandra.jdbc.internal.google.common.base.Strings;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class CassandraDatabaseMetaData
extends BaseJdbcObject
implements DatabaseMetaData {
    private static final String DEFAULT_PRODUCT_NAME = "Apache Cassandra";
    private static final String DEFAULT_PRODUCT_VERSION = "2.x";
    private static final String CQL_TO_GET_VERSION = "-- set consistency_level = LOCAL_ONE\nselect release_version from system.local where key='local' limit 1";
    private static final String CQL_SYS_FUNCTIONS = "maxTimeuuid,minTimeuuid,now,token,uuid";
    private static final String CQL_NUM_FUNCTIONS = "avg,count,max,min,sum";
    private static final String CQL_TIME_FUNCTIONS = "toDate,toTimestamp,toUnixTimestamp,dateOf,unixTimestampOf";
    private final BaseCassandraConnection _conn;
    private final Properties _props;
    private boolean populated = false;

    protected CassandraDatabaseMetaData(BaseCassandraConnection conn) {
        super(conn == null || conn.quiet);
        this._conn = conn;
        this._props = new Properties();
    }

    @Override
    protected SQLException tryClose() {
        return null;
    }

    @Override
    protected Object unwrap() {
        return this;
    }

    @Override
    protected void validateState() throws SQLException {
        if (this._conn == null || this._conn.isClosed()) {
            throw CassandraErrors.connectionClosedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void populate() {
        if (!this.populated) {
            Statement stmt = null;
            try {
                stmt = this._conn.createStatement();
                ResultSet rs = stmt.executeQuery(CQL_TO_GET_VERSION);
                String dbVersion = null;
                if (rs.next()) {
                    dbVersion = rs.getString(1);
                }
                if (!Strings.isNullOrEmpty(dbVersion)) {
                    this.setProperty("productVersion", dbVersion);
                    List<String> versions = CassandraConfiguration.versionSplitter.splitToList(dbVersion);
                    if (versions.size() > 1) {
                        this.setProperty("dbMajorVersion", versions.get(0));
                        this.setProperty("dbMinorVersion", versions.get(1));
                    }
                }
                this.populated = true;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            finally {
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return false;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return true;
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        this.validateState();
        if (!this.quiet) {
            throw CassandraErrors.notSupportedException();
        }
        return CassandraUtils.DUMMY_RESULT_SET;
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        this.validateState();
        if (!this.quiet) {
            throw CassandraErrors.notSupportedException();
        }
        return CassandraUtils.DUMMY_RESULT_SET;
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        this.validateState();
        if (!this.quiet) {
            throw CassandraErrors.notSupportedException();
        }
        return CassandraUtils.DUMMY_RESULT_SET;
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return ".";
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return "";
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        this.validateState();
        if (!this.quiet) {
            throw CassandraErrors.notSupportedException();
        }
        return CassandraUtils.DUMMY_RESULT_SET;
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        this.validateState();
        if (!this.quiet) {
            throw CassandraErrors.notSupportedException();
        }
        return CassandraUtils.DUMMY_RESULT_SET;
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        this.validateState();
        Properties queryPatterns = new Properties();
        queryPatterns.setProperty("catalog", CassandraUtils.isNullOrEmptyString(catalog) ? "" : catalog);
        queryPatterns.setProperty("schemaPattern", CassandraUtils.isNullOrEmptyString(schemaPattern) ? "" : schemaPattern);
        queryPatterns.setProperty("tableNamePattern", CassandraUtils.isNullOrEmptyString(tableNamePattern) ? "" : tableNamePattern);
        queryPatterns.setProperty("columnNamePattern", CassandraUtils.isNullOrEmptyString(columnNamePattern) ? "" : columnNamePattern);
        return this._conn.getObjectMetaData(CassandraObjectType.COLUMN, queryPatterns, new Object[0]);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this._conn;
    }

    @Override
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        this.validateState();
        if (!this.quiet) {
            throw CassandraErrors.notSupportedException();
        }
        return CassandraUtils.DUMMY_RESULT_SET;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        this.populate();
        return Integer.parseInt(CassandraUtils.getPropertyValue(this._props, "dbMajorVersion", "2"));
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        this.populate();
        return Integer.parseInt(CassandraUtils.getPropertyValue(this._props, "dbMinorVersion", "0"));
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return CassandraUtils.getPropertyValue(this._props, "productName", DEFAULT_PRODUCT_NAME);
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        this.populate();
        return CassandraUtils.getPropertyValue(this._props, "productVersion", DEFAULT_PRODUCT_VERSION);
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public int getDriverMajorVersion() {
        return CassandraConfiguration.VERSION_MAJOR;
    }

    @Override
    public int getDriverMinorVersion() {
        return CassandraConfiguration.VERSION_MINOR;
    }

    @Override
    public String getDriverName() throws SQLException {
        return CassandraUtils.getPropertyValue(this._props, "driverName", "Cassandra JDBC Driver");
    }

    @Override
    public String getDriverVersion() throws SQLException {
        return CassandraUtils.getPropertyValue(this._props, "driverVersion", CassandraConfiguration.DRIVER_VERSION);
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        this.validateState();
        if (!this.quiet) {
            throw CassandraErrors.notSupportedException();
        }
        return CassandraUtils.DUMMY_RESULT_SET;
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        return "";
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        this.validateState();
        if (!this.quiet) {
            throw CassandraErrors.notSupportedException();
        }
        return CassandraUtils.DUMMY_RESULT_SET;
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        this.validateState();
        if (!this.quiet) {
            throw CassandraErrors.notSupportedException();
        }
        return CassandraUtils.DUMMY_RESULT_SET;
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return "\"";
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        this.validateState();
        if (!this.quiet) {
            throw CassandraErrors.notSupportedException();
        }
        return CassandraUtils.DUMMY_RESULT_SET;
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        this.validateState();
        Properties queryPatterns = new Properties();
        queryPatterns.setProperty("catalog", CassandraUtils.isNullOrEmptyString(catalog) ? "" : catalog);
        queryPatterns.setProperty("schemaPattern", CassandraUtils.isNullOrEmptyString(schema) ? "" : schema);
        queryPatterns.setProperty("tableNamePattern", CassandraUtils.isNullOrEmptyString(table) ? "" : table);
        queryPatterns.setProperty("uniqueIndexOnly", Boolean.toString(unique));
        queryPatterns.setProperty("approximateIndexInfo", Boolean.toString(approximate));
        return this._conn.getObjectMetaData(CassandraObjectType.INDEX, queryPatterns, new Object[0]);
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        return 4;
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        return 32;
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return 65535;
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        return 32;
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        return 0;
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return CQL_NUM_FUNCTIONS;
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        this.validateState();
        Properties queryPatterns = new Properties();
        queryPatterns.setProperty("catalog", CassandraUtils.isNullOrEmptyString(catalog) ? "" : catalog);
        queryPatterns.setProperty("schemaPattern", CassandraUtils.isNullOrEmptyString(schema) ? "" : schema);
        queryPatterns.setProperty("tableNamePattern", CassandraUtils.isNullOrEmptyString(table) ? "" : table);
        return this._conn.getObjectMetaData(CassandraObjectType.PRIMARY_KEY, queryPatterns, new Object[0]);
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        this.validateState();
        if (!this.quiet) {
            throw CassandraErrors.notSupportedException();
        }
        return CassandraUtils.DUMMY_RESULT_SET;
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        this.validateState();
        if (!this.quiet) {
            throw CassandraErrors.notSupportedException();
        }
        return CassandraUtils.DUMMY_RESULT_SET;
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return "";
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        this.validateState();
        if (!this.quiet) {
            throw CassandraErrors.notSupportedException();
        }
        return CassandraUtils.DUMMY_RESULT_SET;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        return RowIdLifetime.ROWID_UNSUPPORTED;
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        this.validateState();
        return this._conn.getObjectMetaData(CassandraObjectType.KEYSPACE, null, new Object[0]);
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        this.validateState();
        Properties queryPatterns = new Properties();
        queryPatterns.setProperty("catalog", CassandraUtils.isNullOrEmptyString(catalog) ? "" : catalog);
        queryPatterns.setProperty("schemaPattern", CassandraUtils.isNullOrEmptyString(schemaPattern) ? "" : schemaPattern);
        return this._conn.getObjectMetaData(CassandraObjectType.KEYSPACE, queryPatterns, new Object[0]);
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return "KEYSPACE";
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return "\\";
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        return CassandraUtils.getPropertyValue(this._props, "keywords");
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return 2;
    }

    @Override
    public String getStringFunctions() throws SQLException {
        return "";
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        this.validateState();
        if (!this.quiet) {
            throw CassandraErrors.notSupportedException();
        }
        return CassandraUtils.DUMMY_RESULT_SET;
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        this.validateState();
        if (!this.quiet) {
            throw CassandraErrors.notSupportedException();
        }
        return CassandraUtils.DUMMY_RESULT_SET;
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return CQL_SYS_FUNCTIONS;
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        this.validateState();
        if (!this.quiet) {
            throw CassandraErrors.notSupportedException();
        }
        return CassandraUtils.DUMMY_RESULT_SET;
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        this.validateState();
        Properties queryPatterns = new Properties();
        queryPatterns.setProperty("catalog", CassandraUtils.isNullOrEmptyString(catalog) ? "" : catalog);
        queryPatterns.setProperty("schemaPattern", CassandraUtils.isNullOrEmptyString(schemaPattern) ? "" : schemaPattern);
        queryPatterns.setProperty("tableNamePattern", CassandraUtils.isNullOrEmptyString(tableNamePattern) ? "" : tableNamePattern);
        return this._conn.getObjectMetaData(CassandraObjectType.TABLE, queryPatterns, types);
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        this.validateState();
        return this._conn.getObjectMetaData(CassandraObjectType.TABLE_TYPE, null, new Object[0]);
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        return CQL_TIME_FUNCTIONS;
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        return this._conn.getObjectMetaData(CassandraObjectType.TYPE, null, new Object[0]);
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        this.validateState();
        Properties queryPatterns = new Properties();
        queryPatterns.setProperty("catalog", CassandraUtils.isNullOrEmptyString(catalog) ? "" : catalog);
        queryPatterns.setProperty("schemaPattern", CassandraUtils.isNullOrEmptyString(schemaPattern) ? "" : schemaPattern);
        queryPatterns.setProperty("typeNamePattern", CassandraUtils.isNullOrEmptyString(typeNamePattern) ? "" : typeNamePattern);
        return this._conn.getObjectMetaData(CassandraObjectType.UDT, queryPatterns, new Object[]{types});
    }

    @Override
    public String getURL() throws SQLException {
        return this._conn.config.getConnectionUrl();
    }

    @Override
    public String getUserName() throws SQLException {
        return this._conn.config.getUserName();
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        this.validateState();
        if (!this.quiet) {
            throw CassandraErrors.notSupportedException();
        }
        return CassandraUtils.DUMMY_RESULT_SET;
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        return false;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.validateState();
        return this._conn.isReadOnly();
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        return false;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    public void setProperties(Properties props) {
        if (props != null) {
            this._props.putAll((Map<?, ?>)props);
        }
    }

    public String setProperty(String key, String value) {
        Object oldValue = this._props.setProperty(key, value);
        return oldValue == null ? null : oldValue.toString();
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        return type == 1003 && concurrency == 1007;
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return holdability == 1;
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        return type == 1003;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        return level == 0;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        return false;
    }
}

