/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc;

import com.github.cassandra.jdbc.CassandraDataType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class CassandraDataTypeMappings {
    public static final CassandraDataTypeMappings instance = new CassandraDataTypeMappings();
    private final Map<String, Class<?>> cql2JavaMapping = new HashMap();
    private final Map<String, Integer> cql2JdbcMapping = new HashMap<String, Integer>();
    private final Map<String, Integer> precisionMapping = new HashMap<String, Integer>();
    private final Map<String, Integer> scaleMapping = new HashMap<String, Integer>();
    private final Object[][] typeMetaData;

    protected void init(List<Object[]> list) {
        this.addMappings(list, CassandraDataType.ASCII.getTypeName(), 12, String.class, Integer.MAX_VALUE, 0);
        this.addMappings(list, CassandraDataType.BIGINT.getTypeName(), -5, Long.class, 20, 0);
        this.addMappings(list, CassandraDataType.BLOB.getTypeName(), 2004, byte[].class, Integer.MAX_VALUE, 0);
        this.addMappings(list, CassandraDataType.BOOLEAN.getTypeName(), 16, Boolean.class, 1, 0);
        this.addMappings(list, CassandraDataType.COUNTER.getTypeName(), -5, Long.class, 20, 0);
        this.addMappings(list, CassandraDataType.DATE.getTypeName(), 91, Date.class, 10, 0);
        this.addMappings(list, CassandraDataType.DECIMAL.getTypeName(), 3, BigDecimal.class, 10, 0);
        this.addMappings(list, CassandraDataType.DOUBLE.getTypeName(), 8, Double.class, 22, 31);
        this.addMappings(list, CassandraDataType.FLOAT.getTypeName(), 6, Float.class, 12, 31);
        this.addMappings(list, CassandraDataType.INET.getTypeName(), 12, InetAddress.class, 200, 0);
        this.addMappings(list, CassandraDataType.INT.getTypeName(), 4, Integer.class, 10, 0);
        this.addMappings(list, CassandraDataType.LIST.getTypeName(), 12, List.class, Integer.MAX_VALUE, 0);
        this.addMappings(list, CassandraDataType.MAP.getTypeName(), 12, Map.class, Integer.MAX_VALUE, 0);
        this.addMappings(list, CassandraDataType.SET.getTypeName(), 12, Set.class, Integer.MAX_VALUE, 0);
        this.addMappings(list, CassandraDataType.SMALLINT.getTypeName(), 5, Short.class, 6, 0);
        this.addMappings(list, CassandraDataType.TEXT.getTypeName(), 12, String.class, Integer.MAX_VALUE, 0);
        this.addMappings(list, CassandraDataType.TIME.getTypeName(), 92, Time.class, 8, 0);
        this.addMappings(list, CassandraDataType.TIMESTAMP.getTypeName(), 93, Timestamp.class, 19, 0);
        this.addMappings(list, CassandraDataType.TIMEUUID.getTypeName(), 1, UUID.class, 36, 0);
        this.addMappings(list, CassandraDataType.TINYINT.getTypeName(), -6, Byte.class, 4, 0);
        this.addMappings(list, CassandraDataType.TUPLE.getTypeName(), 1111, Object.class, Integer.MAX_VALUE, 0);
        this.addMappings(list, CassandraDataType.UUID.getTypeName(), 1, UUID.class, 36, 0);
        this.addMappings(list, CassandraDataType.VARCHAR.getTypeName(), 12, String.class, Integer.MAX_VALUE, 0);
        this.addMappings(list, CassandraDataType.VARINT.getTypeName(), -5, BigInteger.class, Integer.MAX_VALUE, 0);
    }

    protected CassandraDataTypeMappings() {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        this.init(list);
        this.typeMetaData = new Object[list.size()][];
        int index = 0;
        for (Object[] objs : list) {
            this.typeMetaData[index++] = objs;
        }
    }

    protected void addMappings(List<Object[]> list, String cqlType, int sqlType, Class<?> javaType, int precision, int scale) {
        this.cql2JdbcMapping.put(cqlType, sqlType);
        this.cql2JavaMapping.put(cqlType, javaType);
        this.precisionMapping.put(cqlType, precision);
        this.scaleMapping.put(cqlType, scale);
        list.add(new Object[]{cqlType, sqlType, 0, null, null, null, 1, true, 0, false, false, false, null, 0, 0, 0, 0, 10});
    }

    protected Object[][] getTypeMetaData() {
        return this.typeMetaData;
    }

    public String cqlTypeFor(String cqlType) {
        String recognizedCqlType = this.cql2JdbcMapping.containsKey(cqlType) ? cqlType : (cqlType.startsWith(CassandraDataType.LIST.getTypeName()) ? CassandraDataType.LIST.getTypeName() : (cqlType.startsWith(CassandraDataType.SET.getTypeName()) ? CassandraDataType.SET.getTypeName() : (cqlType.startsWith(CassandraDataType.MAP.getTypeName()) ? CassandraDataType.MAP.getTypeName() : (cqlType.startsWith(CassandraDataType.TUPLE.getTypeName()) ? CassandraDataType.TUPLE.getTypeName() : CassandraDataType.BLOB.getTypeName()))));
        return recognizedCqlType;
    }

    public Class<?> javaTypeFor(String cqlType) {
        return this.cql2JavaMapping.containsKey(cqlType) ? this.cql2JavaMapping.get(cqlType) : String.class;
    }

    public int precisionFor(String cqlType) {
        return this.precisionMapping.containsKey(cqlType) ? this.precisionMapping.get(cqlType) : 0;
    }

    public int scaleFor(String cqlType) {
        return this.scaleMapping.containsKey(cqlType) ? this.scaleMapping.get(cqlType) : 0;
    }

    public int sqlTypeFor(String cqlType) {
        return this.cql2JdbcMapping.containsKey(cqlType) ? this.cql2JdbcMapping.get(cqlType) : 12;
    }
}

