/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc;

import com.github.cassandra.jdbc.CassandraBlob;
import com.github.cassandra.jdbc.CassandraErrors;
import com.github.cassandra.jdbc.internal.google.common.base.Function;
import com.github.cassandra.jdbc.internal.google.common.base.Splitter;
import com.github.cassandra.jdbc.internal.google.common.collect.ImmutableList;
import com.github.cassandra.jdbc.internal.google.common.collect.ImmutableMap;
import com.github.cassandra.jdbc.internal.google.common.collect.ImmutableSet;
import com.github.cassandra.jdbc.internal.google.common.collect.Lists;
import com.github.cassandra.jdbc.internal.google.common.collect.Sets;
import com.github.cassandra.jdbc.internal.google.common.io.ByteStreams;
import com.github.cassandra.jdbc.internal.google.common.io.CharStreams;
import com.github.cassandra.jdbc.internal.google.common.primitives.Doubles;
import com.github.cassandra.jdbc.internal.google.common.primitives.Ints;
import com.github.cassandra.jdbc.internal.joda.time.Instant;
import com.github.cassandra.jdbc.internal.joda.time.LocalDate;
import com.github.cassandra.jdbc.internal.joda.time.LocalTime;
import com.github.cassandra.jdbc.internal.tinylog.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.sql.Blob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class CassandraDataTypeConverters {
    private static final Splitter valueSplitter = Splitter.on(',').trimResults().omitEmptyStrings();
    private static final byte[] emptyByteArray = new byte[0];
    private static final List emptyList = ImmutableList.builder().build();
    private static final Set emptySet = ImmutableSet.builder().build();
    private static final Map emptyMap = ImmutableMap.builder().build();
    static final CassandraDataTypeConverters instance = new CassandraDataTypeConverters();
    private final Map<String, Object> defaultValues = new HashMap<String, Object>();
    private final Map<String, Function> typeMappings = new HashMap<String, Function>();

    protected void init() {
        this.addMapping(String.class, "null", new Function<Object, String>(){

            @Override
            public String apply(Object input) {
                String result;
                if (input instanceof Readable) {
                    try {
                        result = CharStreams.toString((Readable)input);
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException("Failed to read from Readable " + input, e);
                    }
                } else {
                    result = String.valueOf(input);
                }
                return result;
            }
        });
        this.addMapping(UUID.class, UUID.randomUUID(), new Function<Object, UUID>(){

            @Override
            public UUID apply(Object input) {
                return UUID.fromString(String.valueOf(input));
            }
        });
        InetAddress defaultAddress = null;
        try {
            defaultAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            Logger.warn(e, "Failed to get local host", new Object[0]);
        }
        this.addMapping(InetAddress.class, defaultAddress, new Function<Object, InetAddress>(){

            @Override
            public InetAddress apply(Object input) {
                try {
                    return InetAddress.getByName(String.valueOf(input));
                }
                catch (UnknownHostException e) {
                    throw CassandraErrors.unexpectedException(e);
                }
            }
        });
        this.addMapping(Blob.class, new CassandraBlob(new byte[0]), new Function<Object, Blob>(){

            @Override
            public Blob apply(Object input) {
                CassandraBlob blob;
                if (input instanceof ByteBuffer) {
                    blob = new CassandraBlob((ByteBuffer)input);
                } else if (input instanceof byte[]) {
                    blob = new CassandraBlob((byte[])input);
                } else if (input instanceof InputStream) {
                    try {
                        blob = new CassandraBlob(ByteStreams.toByteArray((InputStream)input));
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException("Failed to read from input stream " + input, e);
                    }
                } else {
                    blob = new CassandraBlob(String.valueOf(input).getBytes());
                }
                return blob;
            }
        });
        this.addMapping(byte[].class, emptyByteArray, new Function<Object, byte[]>(){

            @Override
            public byte[] apply(Object input) {
                byte[] result = input instanceof ByteBuffer ? ((ByteBuffer)input).array() : String.valueOf(input).getBytes();
                return result;
            }
        });
        this.addMapping(Boolean.class, Boolean.FALSE, new Function<Object, Boolean>(){

            @Override
            public Boolean apply(Object input) {
                return Boolean.valueOf(String.valueOf(input));
            }
        });
        this.addMapping(Byte.class, (byte)0, new Function<Object, Byte>(){

            @Override
            public Byte apply(Object input) {
                return input instanceof Number ? ((Number)input).byteValue() : Ints.tryParse(String.valueOf(input)).byteValue();
            }
        });
        this.addMapping(Short.class, (short)0, new Function<Object, Short>(){

            @Override
            public Short apply(Object input) {
                return input instanceof Number ? ((Number)input).shortValue() : Ints.tryParse(String.valueOf(input)).shortValue();
            }
        });
        this.addMapping(Integer.class, 0, new Function<Object, Integer>(){

            @Override
            public Integer apply(Object input) {
                return input instanceof Number ? ((Number)input).intValue() : Ints.tryParse(String.valueOf(input)).intValue();
            }
        });
        this.addMapping(Long.class, 0L, new Function<Object, Long>(){

            @Override
            public Long apply(Object input) {
                return input instanceof Number ? ((Number)input).longValue() : Long.parseLong(String.valueOf(input));
            }
        });
        this.addMapping(Float.class, Float.valueOf(0.0f), new Function<Object, Float>(){

            @Override
            public Float apply(Object input) {
                return Float.valueOf(input instanceof Number ? ((Number)input).floatValue() : Doubles.tryParse(String.valueOf(input)).floatValue());
            }
        });
        this.addMapping(Double.class, 0.0, new Function<Object, Double>(){

            @Override
            public Double apply(Object input) {
                return input instanceof Number ? ((Number)input).doubleValue() : Doubles.tryParse(String.valueOf(input)).doubleValue();
            }
        });
        this.addMapping(BigDecimal.class, BigDecimal.ZERO, new Function<Object, BigDecimal>(){

            @Override
            public BigDecimal apply(Object input) {
                return new BigDecimal(String.valueOf(input));
            }
        });
        this.addMapping(BigInteger.class, BigInteger.ZERO, new Function<Object, BigInteger>(){

            @Override
            public BigInteger apply(Object input) {
                return new BigInteger(String.valueOf(input));
            }
        });
        this.addMapping(Date.class, new Date(System.currentTimeMillis()), new Function<Object, Date>(){

            @Override
            public Date apply(Object input) {
                Date result = input instanceof LocalDate ? new Date(((LocalDate)input).toDate().getTime()) : (input instanceof java.util.Date ? new Date(((java.util.Date)input).getTime()) : new Date(LocalDate.parse(String.valueOf(input)).toDate().getTime()));
                return result;
            }
        });
        this.addMapping(Time.class, new Time(System.currentTimeMillis()), new Function<Object, Time>(){

            @Override
            public Time apply(Object input) {
                Time result = input instanceof LocalTime ? new Time(((LocalTime)input).toDateTimeToday().getMillis()) : (input instanceof java.util.Date ? new Time(((java.util.Date)input).getTime()) : new Time(LocalTime.parse(String.valueOf(input)).toDateTimeToday().getMillis()));
                return result;
            }
        });
        this.addMapping(Timestamp.class, new Timestamp(System.currentTimeMillis()), new Function<Object, Timestamp>(){

            @Override
            public Timestamp apply(Object input) {
                Timestamp result;
                if (input instanceof Instant) {
                    result = new Timestamp(((Instant)input).toDate().getTime());
                } else if (input instanceof java.util.Date) {
                    result = new Timestamp(((java.util.Date)input).getTime());
                } else if (input instanceof Number) {
                    result = new Timestamp(((Number)input).longValue());
                } else {
                    String dateTime = String.valueOf(input);
                    if (dateTime.indexOf(32) == 10 && dateTime.indexOf(90) < 0) {
                        StringBuilder builder = new StringBuilder(dateTime).append('Z');
                        builder.setCharAt(10, 'T');
                        dateTime = builder.toString();
                    }
                    result = new Timestamp(Instant.parse(dateTime).toDate().getTime());
                }
                return result;
            }
        });
        this.addMapping(List.class, emptyList, new Function<Object, List>(){

            @Override
            public List apply(Object input) {
                List<Object> result = input instanceof Iterable ? Lists.newArrayList((Iterable)input) : (input instanceof Object[] ? Lists.newArrayList((Object[])input) : valueSplitter.splitToList(String.valueOf(input)));
                return result;
            }
        });
        this.addMapping(Set.class, emptySet, new Function<Object, Set>(){

            @Override
            public Set apply(Object input) {
                AbstractSet result = input instanceof Iterable ? Sets.newTreeSet((Iterable)input) : (input instanceof Object[] ? Sets.newHashSet((Object[])input) : Sets.newTreeSet(valueSplitter.splitToList(String.valueOf(input))));
                return result;
            }
        });
        this.addMapping(Set.class, emptyMap, new Function<Object, Map>(){

            @Override
            public Map apply(Object input) {
                return (Map)Map.class.cast(input);
            }
        });
    }

    protected void addMapping(Class clazz, Object defaultValue, Function converter) {
        String key;
        String string = key = clazz == null ? null : clazz.getName();
        if (defaultValue != null) {
            this.defaultValues.put(key, defaultValue);
        }
        if (converter != null) {
            this.typeMappings.put(key, converter);
        }
    }

    protected CassandraDataTypeConverters() {
        this.init();
    }

    public <T> T defaultValueOf(Class<T> type) {
        return (T)this.defaultValues.get(type.getName());
    }

    public <T> T convert(Object value, Class<T> type, boolean replaceNullValue) {
        Function func;
        String key = type.getName();
        Object result = value == null ? (replaceNullValue ? this.defaultValues.get(key) : null) : (type.isInstance(value) ? value : ((func = this.typeMappings.get(key)) == null ? type.cast(value) : func.apply(value)));
        return (T)result;
    }
}

