/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc;

import com.github.cassandra.jdbc.CassandraConfiguration;
import com.github.cassandra.jdbc.CassandraEnums;
import com.github.cassandra.jdbc.CassandraStatementType;
import com.github.cassandra.jdbc.internal.google.common.base.Objects;
import com.github.cassandra.jdbc.internal.google.common.base.Strings;
import com.github.cassandra.jdbc.internal.google.common.primitives.Ints;
import java.util.Map;
import java.util.Properties;

public class CassandraCqlStmtConfiguration {
    private static final String FLD_STATEMENT_TYPE = "StatementType";
    private static final String FLD_SERIAL_CONSISTENCY_LEVEL = "SerialConsistencyLevel";
    private static final String KEY_CONSISTENCY_LEVEL = "consistency_level";
    private static final String KEY_FETCH_SIZE = "fetch_size";
    private static final String KEY_NO_LIMIT = "no_limit";
    private static final String KEY_NO_WAIT = "no_wait";
    private static final String KEY_READ_TIMEOUT = "read_timeout";
    private static final String KEY_REPLACE_NULL_VALUE = "replace_null_value";
    private static final String KEY_SQL_PARSER = "sql_parser";
    private static final String KEY_TRACING = "tracing";
    private final CassandraStatementType stmtType;
    private final CassandraConfiguration connectionConfig;
    private final String consistencyLevel;
    private final String serialConsistencyLevel;
    private final int fetchSize;
    private final boolean noLimit;
    private final boolean noWait;
    private final int readTimeout;
    private final boolean replaceNullValue;
    private final boolean sqlParser;
    private final boolean tracing;

    public CassandraCqlStmtConfiguration(CassandraConfiguration connectionConfig, CassandraStatementType stmtType, Map<String, String> stmtOptions) {
        this.connectionConfig = connectionConfig;
        this.stmtType = stmtType;
        Properties options = new Properties();
        if (stmtOptions != null) {
            options.putAll(stmtOptions);
        }
        CassandraEnums.ConsistencyLevel preferredCL = connectionConfig.getConsistencyLevel();
        if (stmtType.isQuery()) {
            preferredCL = connectionConfig.getReadConsistencyLevel();
        } else if (stmtType.isUpdate()) {
            preferredCL = connectionConfig.getWriteConsistencyLevel();
        }
        this.consistencyLevel = options.getProperty(KEY_CONSISTENCY_LEVEL, preferredCL.name()).trim().toUpperCase();
        this.serialConsistencyLevel = stmtType.isUpdate() && (preferredCL == CassandraEnums.ConsistencyLevel.LOCAL_SERIAL || preferredCL == CassandraEnums.ConsistencyLevel.SERIAL) ? preferredCL.name() : null;
        String value = options.getProperty(KEY_FETCH_SIZE);
        this.fetchSize = Strings.isNullOrEmpty(value) ? -1 : Ints.tryParse(value);
        this.noLimit = Boolean.valueOf(options.getProperty(KEY_NO_LIMIT, null));
        this.noWait = Boolean.valueOf(options.getProperty(KEY_NO_WAIT, null));
        this.tracing = Boolean.valueOf(options.getProperty(KEY_TRACING, String.valueOf(connectionConfig.isTracingEnabled())));
        value = options.getProperty(KEY_READ_TIMEOUT);
        this.readTimeout = Strings.isNullOrEmpty(value) ? connectionConfig.getReadTimeout() : Ints.tryParse(value) * 1000;
        this.replaceNullValue = Boolean.valueOf(options.getProperty(KEY_REPLACE_NULL_VALUE, null));
        this.sqlParser = Boolean.valueOf(options.getProperty(KEY_SQL_PARSER, String.valueOf(connectionConfig.isSqlFriendly())));
    }

    public CassandraConfiguration getConnectionConfig() {
        return this.connectionConfig;
    }

    public boolean hasSetFetchSize() {
        return this.fetchSize > 0;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public CassandraStatementType getStatementType() {
        return this.stmtType;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public String getConsistencyLevel() {
        return this.consistencyLevel;
    }

    public String getSerialConsistencyLevel() {
        return this.serialConsistencyLevel;
    }

    public boolean noLimit() {
        return this.noLimit;
    }

    public boolean noWait() {
        return this.noWait;
    }

    public boolean tracingEnabled() {
        return this.tracing;
    }

    public boolean sqlParserEnabled() {
        return this.sqlParser;
    }

    public boolean replaceNullValue() {
        return this.replaceNullValue;
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.stmtType, this.consistencyLevel, this.serialConsistencyLevel, this.fetchSize, this.noLimit, this.noWait, this.tracing, this.readTimeout, this.replaceNullValue, this.sqlParser});
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CassandraCqlStmtConfiguration other = (CassandraCqlStmtConfiguration)obj;
        return Objects.equal((Object)this.stmtType, (Object)other.stmtType) && Objects.equal(this.consistencyLevel, other.consistencyLevel) && Objects.equal(this.serialConsistencyLevel, other.serialConsistencyLevel) && Objects.equal(this.fetchSize, other.fetchSize) && Objects.equal(this.noLimit, other.noLimit) && Objects.equal(this.noWait, other.noWait) && Objects.equal(this.tracing, other.tracing) && Objects.equal(this.readTimeout, other.readTimeout) && Objects.equal(this.replaceNullValue, other.replaceNullValue) && Objects.equal(this.sqlParser, other.sqlParser);
    }

    public String toString() {
        return Objects.toStringHelper(this).add(FLD_STATEMENT_TYPE, (Object)this.stmtType).add(KEY_CONSISTENCY_LEVEL, this.consistencyLevel).add(FLD_SERIAL_CONSISTENCY_LEVEL, this.serialConsistencyLevel).add(KEY_FETCH_SIZE, this.fetchSize).add(KEY_NO_LIMIT, this.noLimit).add(KEY_NO_WAIT, this.noWait).add(KEY_TRACING, this.tracing).add(KEY_READ_TIMEOUT, this.readTimeout).add(KEY_REPLACE_NULL_VALUE, this.replaceNullValue).add(KEY_SQL_PARSER, this.sqlParser).toString();
    }
}

