/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc;

import com.github.cassandra.jdbc.CassandraCqlStmtConfiguration;
import com.github.cassandra.jdbc.internal.google.common.base.Objects;
import com.github.cassandra.jdbc.internal.google.common.base.Strings;

public class CassandraCqlStatement {
    private final String cql;
    private final CassandraCqlStmtConfiguration config;
    private final Object[] parameters;

    public CassandraCqlStatement(String cql, CassandraCqlStmtConfiguration config, Object ... params) {
        this.cql = Strings.nullToEmpty(cql);
        this.config = config;
        this.parameters = new Object[params == null ? 0 : params.length];
        if (params != null) {
            int index = 0;
            for (Object p : params) {
                this.parameters[index++] = p;
            }
        }
    }

    public String getCql() {
        return this.cql;
    }

    public CassandraCqlStmtConfiguration getConfiguration() {
        return this.config;
    }

    public boolean hasParameter() {
        return this.parameters.length > 0;
    }

    public Object[] getParameters() {
        Object[] params = new Object[this.parameters.length];
        System.arraycopy(this.parameters, 0, params, 0, this.parameters.length);
        return params;
    }

    public int hashCode() {
        return Objects.hashCode(this.cql, this.config, this.parameters);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CassandraCqlStatement other = (CassandraCqlStatement)obj;
        return Objects.equal(this.cql, other.cql) && Objects.equal(this.config, other.config) && Objects.equal(this.parameters, other.parameters);
    }

    public String toString() {
        return Objects.toStringHelper(this).addValue(this.cql).addValue(this.config).addValue(this.parameters).toString();
    }
}

