/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc;

import com.github.cassandra.jdbc.CassandraConfiguration;
import com.github.cassandra.jdbc.CassandraCqlStatement;
import com.github.cassandra.jdbc.CassandraCqlStmtConfiguration;
import com.github.cassandra.jdbc.CassandraErrors;
import com.github.cassandra.jdbc.CassandraStatementType;
import com.github.cassandra.jdbc.cql.CqlSelectFormatter;
import com.github.cassandra.jdbc.cql.SqlToCqlTranslator;
import com.github.cassandra.jdbc.internal.antlr.runtime.ANTLRStringStream;
import com.github.cassandra.jdbc.internal.antlr.runtime.CommonTokenStream;
import com.github.cassandra.jdbc.internal.cassandra.cql3.CqlLexer;
import com.github.cassandra.jdbc.internal.cassandra.cql3.CqlParser;
import com.github.cassandra.jdbc.internal.cassandra.cql3.statements.DeleteStatement;
import com.github.cassandra.jdbc.internal.cassandra.cql3.statements.ModificationStatement;
import com.github.cassandra.jdbc.internal.cassandra.cql3.statements.ParsedStatement;
import com.github.cassandra.jdbc.internal.cassandra.cql3.statements.SelectStatement;
import com.github.cassandra.jdbc.internal.cassandra.cql3.statements.TruncateStatement;
import com.github.cassandra.jdbc.internal.cassandra.cql3.statements.UpdateStatement;
import com.github.cassandra.jdbc.internal.google.common.base.Splitter;
import com.github.cassandra.jdbc.internal.google.common.base.Strings;
import com.github.cassandra.jdbc.internal.google.common.cache.Cache;
import com.github.cassandra.jdbc.internal.google.common.cache.CacheBuilder;
import com.github.cassandra.jdbc.internal.jsqlparser.parser.CCJSqlParserUtil;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.Statement;
import com.github.cassandra.jdbc.internal.jsqlparser.statement.select.Select;
import com.github.cassandra.jdbc.internal.tinylog.Logger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CassandraCqlParser {
    private static final String SQL_KEYWORD_ESCAPING = ".\"$1\"$2";
    private static final Pattern SQL_KEYWORDS_PATTERN = Pattern.compile("(?i)\\.(select|insert|update|delete|into|from|where|key|alter|drop|create)([>=<\\.,\\s])", 40);
    private static final Pattern MAGIC_COMMENT_PATTERN = Pattern.compile("(?i)^(//|--)\\s+set\\s+(.*)$", 8);
    private static final Splitter PARAM_SPLITTER = Splitter.on(';').trimResults().omitEmptyStrings();
    private static final Splitter KVP_SPLITTER = Splitter.on('=').trimResults().limit(2);
    private static final String HINT_ALTER = "Alter";
    private static final String HINT_CREATE = "Create";
    private static final String HINT_DROP = "Drop";
    private static final Cache<String, CassandraCqlStatement> STMT_CACHE = CacheBuilder.newBuilder().maximumSize(CassandraConfiguration.DEFAULT.getCqlCacheSize()).build();

    private static Map<String, String> parseMagicComments(String sql) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        Matcher m = MAGIC_COMMENT_PATTERN.matcher(sql);
        while (m.find()) {
            for (String attr : PARAM_SPLITTER.split(m.group(2))) {
                List<String> kvp = KVP_SPLITTER.splitToList(attr);
                if (kvp.size() != 2) continue;
                attributes.put(kvp.get(0).toLowerCase(), kvp.get(1));
            }
        }
        return attributes;
    }

    private static CassandraCqlStatement parseSql(CassandraConfiguration config, String sql, Map<String, String> hints) {
        CassandraStatementType stmtType = CassandraStatementType.UNKNOWN;
        if (Strings.isNullOrEmpty(sql)) {
            return new CassandraCqlStatement(sql, new CassandraCqlStmtConfiguration(config, stmtType, hints), new Object[0]);
        }
        CassandraCqlStatement sqlStmt = null;
        CassandraCqlStmtConfiguration stmtConfig = null;
        try {
            Matcher m = SQL_KEYWORDS_PATTERN.matcher(sql);
            sql = m.replaceAll(SQL_KEYWORD_ESCAPING);
            Statement s = CCJSqlParserUtil.parse(sql);
            sql = s.toString();
            if (s instanceof Select) {
                stmtType = CassandraStatementType.SELECT;
            } else if (sql.startsWith(CassandraStatementType.INSERT.getType())) {
                stmtType = CassandraStatementType.INSERT;
            } else if (sql.startsWith(CassandraStatementType.UPDATE.getType())) {
                stmtType = CassandraStatementType.UPDATE;
            } else if (sql.startsWith(CassandraStatementType.DELETE.getType())) {
                stmtType = CassandraStatementType.DELETE;
            } else if (sql.startsWith(CassandraStatementType.TRUNCATE.getType())) {
                stmtType = CassandraStatementType.TRUNCATE;
            } else if (sql.startsWith(CassandraStatementType.CREATE.getType())) {
                stmtType = CassandraStatementType.CREATE;
            } else if (sql.startsWith(CassandraStatementType.ALTER.getType())) {
                stmtType = CassandraStatementType.ALTER;
            } else if (sql.startsWith(CassandraStatementType.DROP.getType())) {
                stmtType = CassandraStatementType.DROP;
            }
            stmtConfig = new CassandraCqlStmtConfiguration(config, stmtType, hints);
            if (stmtType.isQuery()) {
                Select select = (Select)s;
                SqlToCqlTranslator trans = new SqlToCqlTranslator(stmtConfig);
                select.getSelectBody().accept(trans);
                sql = select.toString();
            }
        }
        catch (Throwable t) {
            Logger.debug("Failed to parse the given SQL, fall back to CQL parser");
            sqlStmt = CassandraCqlParser.parseCql(config, sql, hints);
            sql = sqlStmt.getCql();
        }
        if (sqlStmt == null) {
            sqlStmt = new CassandraCqlStatement(sql, stmtConfig == null ? new CassandraCqlStmtConfiguration(config, stmtType, hints) : stmtConfig, new Object[0]);
        }
        return sqlStmt;
    }

    private static CassandraCqlStatement parseCql(CassandraConfiguration config, String cql, Map<String, String> hints) {
        CassandraStatementType stmtType = CassandraStatementType.UNKNOWN;
        if (Strings.isNullOrEmpty(cql)) {
            return new CassandraCqlStatement(cql, new CassandraCqlStmtConfiguration(config, stmtType, hints), new Object[0]);
        }
        CassandraCqlStatement cqlStmt = null;
        CassandraCqlStmtConfiguration stmtConfig = null;
        try {
            ANTLRStringStream input = new ANTLRStringStream(cql);
            CqlLexer lexer = new CqlLexer(input);
            CommonTokenStream token = new CommonTokenStream(lexer);
            CqlParser parser = new CqlParser(token);
            ParsedStatement stmt = parser.query();
            Class<?> stmtClass = stmt.getClass().getDeclaringClass();
            if (stmtClass == null) {
                stmtClass = stmt.getClass();
            }
            String stmtClassName = stmtClass.getSimpleName();
            if (ModificationStatement.class.isAssignableFrom(stmtClass)) {
                stmtType = CassandraStatementType.INSERT;
                if (stmtClass == UpdateStatement.class) {
                    stmtType = CassandraStatementType.UPDATE;
                } else if (stmtClass == DeleteStatement.class) {
                    stmtType = CassandraStatementType.DELETE;
                } else if (stmtClass == TruncateStatement.class) {
                    stmtType = CassandraStatementType.TRUNCATE;
                }
            } else if (stmtClass == SelectStatement.class) {
                stmtType = CassandraStatementType.SELECT;
            } else if (stmtClassName.startsWith(HINT_ALTER)) {
                stmtType = CassandraStatementType.ALTER;
            } else if (stmtClassName.startsWith(HINT_CREATE)) {
                stmtType = CassandraStatementType.CREATE;
            } else if (stmtClassName.startsWith(HINT_DROP)) {
                stmtType = CassandraStatementType.DROP;
            }
            stmtConfig = new CassandraCqlStmtConfiguration(config, stmtType, hints);
            if (stmtType.isQuery()) {
                String string = new CqlSelectFormatter().format(stmtConfig, (SelectStatement.RawStatement)stmt);
            }
        }
        catch (Throwable t) {
            Logger.warn(t, "Not able to parse given CQL - treat it as is\n{}\n", cql);
        }
        if (cqlStmt == null) {
            cqlStmt = new CassandraCqlStatement(cql, stmtConfig == null ? new CassandraCqlStmtConfiguration(config, stmtType, hints) : stmtConfig, new Object[0]);
        }
        return cqlStmt;
    }

    public static CassandraCqlStatement parse(final CassandraConfiguration config, final String sql) {
        try {
            CassandraCqlStatement parsedStmt = STMT_CACHE.get(sql, new Callable<CassandraCqlStatement>(){

                @Override
                public CassandraCqlStatement call() throws Exception {
                    String nonNullSql = Strings.nullToEmpty(sql).trim();
                    Map attributes = CassandraCqlParser.parseMagicComments(nonNullSql);
                    return config == null || config.isSqlFriendly() ? CassandraCqlParser.parseSql(config, nonNullSql, attributes) : CassandraCqlParser.parseCql(config, nonNullSql, attributes);
                }
            });
            return parsedStmt;
        }
        catch (ExecutionException e) {
            throw CassandraErrors.unexpectedException(e.getCause());
        }
    }
}

