/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc;

import com.github.cassandra.jdbc.CassandraEnums;
import com.github.cassandra.jdbc.CassandraErrors;
import com.github.cassandra.jdbc.internal.google.common.base.Splitter;
import com.github.cassandra.jdbc.internal.google.common.base.Strings;
import com.github.cassandra.jdbc.internal.google.common.collect.Maps;
import com.github.cassandra.jdbc.internal.google.common.primitives.Ints;
import com.github.cassandra.jdbc.internal.snakeyaml.Yaml;
import com.github.cassandra.jdbc.internal.tinylog.Configurator;
import com.github.cassandra.jdbc.internal.tinylog.Level;
import com.github.cassandra.jdbc.internal.tinylog.Logger;
import java.lang.reflect.Field;
import java.net.URL;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;

public final class CassandraConfiguration {
    public static final Splitter versionSplitter = Splitter.on('.').omitEmptyStrings().trimResults();
    public static final String DRIVER_NAME = "Cassandra JDBC Driver";
    public static final String DRIVER_VERSION;
    public static final int VERSION_MAJOR;
    public static final int VERSION_MINOR;
    static final String INVALID_URL = "Invalid connection URL";
    static final String DRIVER_PROTOCOL = "jdbc:c*:";
    static final String KEY_COMPRESSION = "compression";
    static final String KEY_CONNECTION_TIMEOUT = "connectionTimeout";
    static final String KEY_CONNECTION_URL = "url";
    static final String KEY_CONSISTENCY_LEVEL = "consistencyLevel";
    static final String KEY_FETCH_SIZE = "fetchSize";
    static final String KEY_HOSTS = "hosts";
    static final String KEY_PORT = "port";
    static final String KEY_KEEP_ALIVE = "keepAlive";
    static final String KEY_KEYSPACE = "keyspace";
    static final String KEY_LOCAL_DC = "localDc";
    static final String KEY_USERNAME = "user";
    static final String KEY_PASSWORD = "password";
    static final String KEY_PROVIDER = "provider";
    static final String KEY_QUERY_TRACE = "queryTrace";
    static final String KEY_QUIET = "quiet";
    static final String KEY_READ_TIMEOUT = "readTimeout";
    static final String KEY_SQL_FRIENDLY = "sqlFriendly";
    static final String TOKEN_KVP_SEPARATOR = "=";
    static final String TOKEN_PARAM_SEPARATOR = "&";
    static final String TOKEN_PROTO_SEPARATOR = ":";
    static final String TOKEN_URL_SEPARATOR = "//";
    static final String YAML_KVP_SEPARATOR = " : ";
    static final CassandraConfiguration DEFAULT;
    private final boolean autoCommit = true;
    private final boolean readOnly = false;
    private final String connectionUrl;
    private final DriverConfig config;

    static boolean isValidUrl(String url) {
        return !Strings.isNullOrEmpty(url) && url.startsWith(DRIVER_PROTOCOL);
    }

    static Properties parseConnectionURL(String url) throws SQLException {
        Properties props = new Properties();
        String[] parts = url.split(TOKEN_URL_SEPARATOR);
        boolean invalidUrl = true;
        if (parts.length == 2) {
            String provider = parts[0].substring(DRIVER_PROTOCOL.length());
            if (!Strings.isNullOrEmpty(provider)) {
                provider = provider.split(TOKEN_PROTO_SEPARATOR)[0];
                props.setProperty(KEY_PROVIDER, provider);
            }
            String restUrl = parts[1];
            int ksIdx = restUrl.indexOf(47);
            int pIdx = restUrl.indexOf(63);
            if (ksIdx > 0) {
                String hosts = restUrl.substring(0, ksIdx);
                props.setProperty(KEY_HOSTS, hosts);
                String keyspace = restUrl.substring(ksIdx + 1, pIdx > ksIdx ? pIdx : restUrl.length());
                if (!Strings.isNullOrEmpty(keyspace)) {
                    props.setProperty(KEY_KEYSPACE, keyspace);
                }
            } else {
                props.setProperty(KEY_HOSTS, pIdx > 0 ? restUrl.substring(0, pIdx) : restUrl);
            }
            invalidUrl = false;
            if (pIdx > ksIdx) {
                String[] params;
                for (String param : params = restUrl.substring(pIdx + 1, restUrl.length()).split(TOKEN_PARAM_SEPARATOR)) {
                    String[] kvPair = param.split(TOKEN_KVP_SEPARATOR);
                    if (kvPair.length != 2) continue;
                    String key = kvPair[0].trim();
                    String value = kvPair[1].trim();
                    if (Strings.isNullOrEmpty(key)) continue;
                    props.setProperty(key, value);
                }
            }
        }
        if (invalidUrl) {
            throw new SQLException(INVALID_URL);
        }
        return props;
    }

    static DriverConfig generateDriverConfig(Properties props) {
        Properties current = CassandraConfiguration.DEFAULT.config.toProperties();
        current.putAll((Map<?, ?>)props);
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<Object, Object> entry : current.entrySet()) {
            String key = (String)entry.getKey();
            builder.append(key).append(YAML_KVP_SEPARATOR).append(entry.getValue()).append('\n');
        }
        return new Yaml().loadAs(builder.toString().trim(), DriverConfig.class);
    }

    static String buildSimplifiedConnectionUrl(DriverConfig config) {
        StringBuilder builder = new StringBuilder(DRIVER_PROTOCOL);
        builder.append(config.provider).append(':').append(TOKEN_URL_SEPARATOR).append(config.hosts);
        if (config.port > 0) {
            builder.append(':').append(config.port);
        }
        builder.append('/').append(config.keyspace).append('?').append(KEY_USERNAME).append('=').append(config.user);
        return builder.toString();
    }

    private void init() {
        int tentativePort = this.config.port;
        Splitter splitter = Splitter.on(':').trimResults().omitEmptyStrings().limit(2);
        StringBuilder sb = new StringBuilder();
        for (String host : Splitter.on(',').trimResults().omitEmptyStrings().split(this.config.hosts)) {
            List<String> h = splitter.splitToList(host);
            sb.append(h.get(0)).append(',');
            if (h.size() <= 1 || tentativePort > 0) continue;
            tentativePort = Ints.tryParse(h.get(1));
        }
        this.config.hosts = sb.deleteCharAt(sb.length() - 1).toString();
        this.config.port = tentativePort;
        this.config.connectionTimeout *= 1000;
        this.config.readTimeout *= 1000;
    }

    private CassandraConfiguration(DriverConfig config) throws SQLException {
        this.config = config;
        this.init();
        this.connectionUrl = CassandraConfiguration.buildSimplifiedConnectionUrl(config);
    }

    public CassandraConfiguration(String url, Properties props) throws SQLException {
        Properties connProps = new Properties();
        connProps.putAll((Map<?, ?>)CassandraConfiguration.parseConnectionURL(url));
        connProps.putAll((Map<?, ?>)props);
        this.config = CassandraConfiguration.generateDriverConfig(connProps);
        this.init();
        this.connectionUrl = CassandraConfiguration.buildSimplifiedConnectionUrl(this.config);
    }

    public String getProvider() {
        return this.config.provider;
    }

    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    public String getUserName() {
        return this.config.user;
    }

    public String getPassword() {
        return this.config.password;
    }

    public String getHosts() {
        return this.config.hosts;
    }

    public int getPort() {
        return this.config.port;
    }

    public String getKeyspace() {
        return this.config.keyspace;
    }

    public boolean isAutoCommit() {
        return true;
    }

    public boolean isReadOnly() {
        return false;
    }

    public boolean isSqlFriendly() {
        return this.config.sqlFriendly;
    }

    public boolean isQuiet() {
        return this.config.quiet;
    }

    public boolean isTracingEnabled() {
        return this.config.tracing;
    }

    public int getConnectionTimeout() {
        return this.config.connectionTimeout;
    }

    public int getReadTimeout() {
        return this.config.readTimeout;
    }

    public boolean isKeepAlive() {
        return this.config.keepAlive;
    }

    public CassandraEnums.ConsistencyLevel getReadConsistencyLevel() {
        return this.config.readConsistencyLevel;
    }

    public CassandraEnums.ConsistencyLevel getWriteConsistencyLevel() {
        return this.config.writeConsistencyLevel;
    }

    public CassandraEnums.ConsistencyLevel getConsistencyLevel() {
        return this.config.consistencyLevel;
    }

    @Deprecated
    public String getLocalDc() {
        return this.config.localDc;
    }

    public String getLoadBalancingPolicy() {
        return this.config.loadBalancingPolicy;
    }

    public String getFallbackPolicy() {
        return this.config.fallbackPolicy;
    }

    public CassandraEnums.Batch getBatch() {
        return this.config.batch;
    }

    public int getFetchSize() {
        return this.config.fetchSize;
    }

    public long getRowLimit() {
        return this.config.rowLimit;
    }

    public int getCqlCacheSize() {
        return this.config.cqlCacheSize;
    }

    public CassandraEnums.Compression getCompression() {
        return this.config.compression;
    }

    public String getAdditionalProperty(String key, String defaultValue) {
        return this.config.advanced.getProperty(key, defaultValue);
    }

    public int getAdditionalProperty(String key, int defaultValue) {
        String value = this.getAdditionalProperty(key, null);
        return Strings.isNullOrEmpty(value) ? defaultValue : Integer.valueOf(value);
    }

    public Properties toProperties() {
        return this.config.toProperties();
    }

    public SortedMap<String, Object> toSortedMap() {
        return this.config.toSortedMap();
    }

    static {
        String configUrl = System.getProperty("cassandra.jdbc.driver.config");
        URL url = null;
        if (!Strings.isNullOrEmpty(configUrl)) {
            try {
                url = new URL(configUrl);
                url.openStream().close();
            }
            catch (Exception e) {
                ClassLoader loader = CassandraConfiguration.class.getClassLoader();
                url = loader.getResource(configUrl);
            }
        }
        Yaml yaml = new Yaml();
        YamlConfig defaultConfig = new YamlConfig();
        try {
            defaultConfig = yaml.loadAs(url != null ? url.openStream() : CassandraConfiguration.class.getResourceAsStream("/config.yaml"), YamlConfig.class);
        }
        catch (Throwable t) {
            Logger.warn(t, "Failed to load default configuration, but that's cool", new Object[0]);
        }
        Configurator.defaultConfig().formatPattern(defaultConfig.logger.format).level(defaultConfig.logger.level).locale(defaultConfig.locale).maxStackTraceElements(defaultConfig.logger.stacktrace).activate();
        Logger.info("Configuration loaded from {}", url == null ? "(embedded)config.yaml" : url.toString());
        DRIVER_VERSION = Strings.isNullOrEmpty(defaultConfig.version) ? "0.1.0" : defaultConfig.version;
        List<String> versions = versionSplitter.splitToList(DRIVER_VERSION);
        if (versions.size() > 1) {
            VERSION_MAJOR = Ints.tryParse(versions.get(0));
            VERSION_MINOR = Ints.tryParse(versions.get(1));
        } else {
            VERSION_MAJOR = 0;
            VERSION_MINOR = 1;
        }
        try {
            DEFAULT = new CassandraConfiguration(defaultConfig.driver);
        }
        catch (SQLException e) {
            throw CassandraErrors.unexpectedException(e);
        }
    }

    public static final class YamlConfig {
        public String version = "0.1.0";
        public Locale locale = Locale.US;
        public DriverConfig driver = new DriverConfig();
        public LoggerConfig logger = new LoggerConfig();
    }

    public static final class LoggerConfig {
        public Level level = Level.INFO;
        public int stacktrace = -1;
        public String format = "{date:yyyy-MM-dd HH:mm:ss} [{thread}] {class_name}.{method}({line}) {level}: {message}";
    }

    public static final class DriverConfig {
        public String provider = "datastax";
        public String hosts = "localhost";
        public int port = -1;
        public String keyspace = "system";
        public String user = "cassandra";
        public String password = "cassandra";
        public boolean quiet = true;
        public CassandraEnums.ConsistencyLevel readConsistencyLevel = CassandraEnums.ConsistencyLevel.LOCAL_ONE;
        public CassandraEnums.ConsistencyLevel writeConsistencyLevel = CassandraEnums.ConsistencyLevel.ANY;
        public CassandraEnums.ConsistencyLevel consistencyLevel = this.readConsistencyLevel;
        public boolean sqlFriendly = true;
        public boolean tracing = false;
        public CassandraEnums.Batch batch = CassandraEnums.Batch.UNLOGGED;
        public int fetchSize = 100;
        public long rowLimit = 10000L;
        public int cqlCacheSize = 1000;
        public int readTimeout = 30000;
        public int connectionTimeout = 5000;
        public boolean keepAlive = true;
        public CassandraEnums.Compression compression = CassandraEnums.Compression.LZ4;
        public String localDc = "";
        public String loadBalancingPolicy = "";
        public String fallbackPolicy = "";
        Properties advanced = new Properties();

        public SortedMap<String, Object> toSortedMap() {
            Field[] fields;
            TreeMap<String, Object> map = Maps.newTreeMap();
            for (Field field : fields = DriverConfig.class.getFields()) {
                try {
                    map.put(field.getName(), field.get(this));
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            return map;
        }

        Properties toProperties() {
            Properties props = new Properties();
            props.putAll((Map<?, ?>)this.toSortedMap());
            return props;
        }
    }
}

