/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc;

import com.github.cassandra.jdbc.CassandraDataTypeMappings;
import com.github.cassandra.jdbc.internal.google.common.base.Strings;

public class CassandraColumnDefinition {
    protected final String catalog;
    protected final String cqlType;
    protected final Class<?> javaType;
    protected final String label;
    protected final String name;
    protected final int precision;
    protected final int scale;
    protected final String schema;
    protected final boolean searchable;
    protected final int sqlType;
    protected final String table;
    protected final boolean writable;

    public CassandraColumnDefinition(String schema, String table, String name, String type, boolean searchable) {
        this(schema, table, name, name, type, searchable, false);
    }

    public CassandraColumnDefinition(String schema, String table, String name, String label, String type, boolean searchable, boolean writable) {
        this.catalog = "";
        this.schema = Strings.nullToEmpty(schema);
        this.table = Strings.nullToEmpty(table);
        this.name = Strings.nullToEmpty(name);
        this.label = Strings.isNullOrEmpty(label) ? name : label;
        this.cqlType = CassandraDataTypeMappings.instance.cqlTypeFor(type);
        this.sqlType = CassandraDataTypeMappings.instance.sqlTypeFor(this.cqlType);
        this.javaType = CassandraDataTypeMappings.instance.javaTypeFor(this.cqlType);
        this.searchable = searchable;
        this.writable = writable;
        this.precision = CassandraDataTypeMappings.instance.precisionFor(this.cqlType);
        this.scale = CassandraDataTypeMappings.instance.scaleFor(this.cqlType);
    }

    public String getCatalogName() {
        return this.catalog;
    }

    public Class getColumnClass() {
        return this.javaType;
    }

    public String getColumnClassName() {
        return this.javaType.getName();
    }

    public int getColumnDisplaySize() {
        return 0;
    }

    public String getColumnLabel() {
        return this.label;
    }

    public String getColumnName() {
        return this.name;
    }

    public int getColumnType() {
        return this.sqlType;
    }

    public String getColumnTypeName() {
        return this.cqlType;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public String getSchemaName() {
        return this.schema;
    }

    public String getTableName() {
        return this.table;
    }

    public boolean isAutoIncrement() {
        return false;
    }

    public boolean isCaseSensitive() {
        return true;
    }

    public boolean isCurrency() {
        return false;
    }

    public boolean isDefinitelyWritable() {
        return this.writable;
    }

    public int isNullable() {
        return 1;
    }

    public boolean isReadOnly() {
        return !this.writable;
    }

    public boolean isSearchable() {
        return this.searchable;
    }

    public boolean isSigned() {
        return false;
    }

    public boolean isWritable() {
        return this.writable;
    }
}

