/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc;

import com.github.cassandra.jdbc.CassandraErrors;
import com.github.cassandra.jdbc.internal.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.sql.Blob;
import java.sql.SQLException;

public class CassandraBlob
implements Blob {
    private final ByteBuffer _bytes;

    public CassandraBlob(byte[] bytes) {
        this(ByteBuffer.wrap(bytes == null ? new byte[]{} : bytes));
    }

    public CassandraBlob(ByteBuffer bytes) {
        this._bytes = bytes == null ? ByteBuffer.wrap(new byte[0]) : bytes;
    }

    @Override
    public long length() throws SQLException {
        return this._bytes.capacity();
    }

    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        byte[] bytes = new byte[length];
        this._bytes.get(bytes, (int)pos - 1, length);
        return bytes;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        return new ByteArrayInputStream(this._bytes.array());
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        throw CassandraErrors.notSupportedException();
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException {
        long pos = 0L;
        try {
            pos = this.position(ByteStreams.toByteArray(pattern.getBinaryStream()), start);
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        return pos;
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        return this.setBytes(pos, bytes, 0, bytes.length);
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        if (bytes != null) {
            this._bytes.position((int)pos - 1);
            this._bytes.put(bytes, offset, len);
        }
        return len;
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        throw CassandraErrors.notSupportedException();
    }

    @Override
    public void truncate(long len) throws SQLException {
        this._bytes.limit((int)len);
    }

    @Override
    public void free() throws SQLException {
        this._bytes.clear();
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        return new ByteArrayInputStream(this.getBytes(pos, (int)length));
    }
}

