/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc;

import com.github.cassandra.jdbc.CassandraErrors;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Wrapper;

public abstract class BaseJdbcObject
implements AutoCloseable,
Wrapper {
    private SQLWarning _warning;
    protected boolean closed = false;
    protected final boolean quiet;

    protected BaseJdbcObject(boolean quiet) {
        this.quiet = quiet;
    }

    protected abstract SQLException tryClose();

    protected abstract Object unwrap();

    protected void validateState() throws SQLException {
        if (this.closed) {
            throw CassandraErrors.resourceClosedException(this);
        }
    }

    public void appendWarning(SQLWarning warning) {
        if (warning != null) {
            if (this._warning == null) {
                this._warning = warning;
            } else {
                SQLWarning w;
                SQLWarning prevWarning = w = this._warning;
                while (w != warning) {
                    prevWarning = w;
                    if ((w = w.getNextWarning()) != null) continue;
                }
                if (prevWarning != w) {
                    prevWarning.setNextWarning(warning);
                }
            }
        }
    }

    public void clearWarnings() throws SQLException {
        this._warning = null;
    }

    @Override
    public void close() throws SQLException {
        this.clearWarnings();
        this.closed = true;
        SQLException exception = this.tryClose();
        if (!this.quiet && exception != null) {
            throw exception;
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        this.validateState();
        return this._warning;
    }

    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        Object innerObj = this.unwrap();
        return innerObj != null && innerObj.getClass().isAssignableFrom(iface);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return iface.cast(this.unwrap());
    }
}

