/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc;

import com.github.cassandra.jdbc.BaseCassandraConnection;
import com.github.cassandra.jdbc.BaseJdbcObject;
import com.github.cassandra.jdbc.CassandraConfiguration;
import com.github.cassandra.jdbc.CassandraCqlParser;
import com.github.cassandra.jdbc.CassandraCqlStatement;
import com.github.cassandra.jdbc.CassandraDataTypeConverters;
import com.github.cassandra.jdbc.CassandraDataTypeMappings;
import com.github.cassandra.jdbc.CassandraErrors;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseCassandraStatement
extends BaseJdbcObject
implements Statement {
    private boolean _closeOnCompletion = false;
    private BaseCassandraConnection _connection;
    private String _cursorName;
    protected final List<CassandraCqlStatement> batch = new ArrayList<CassandraCqlStatement>();
    protected final int concurrency = 1007;
    protected boolean escapeProcessing = true;
    protected int fetchDirection = 1000;
    protected int fetchSize = 100;
    protected final int hodability = 1;
    protected int maxFieldSize = 0;
    protected int maxRows = 0;
    protected boolean poolable = false;
    protected int queryTimeout = 0;
    protected final int resultType = 1003;

    protected BaseCassandraStatement(BaseCassandraConnection conn) {
        super(conn == null || conn.quiet);
        this._connection = conn;
        this._cursorName = "cursor@" + conn.hashCode() + '/' + this.hashCode();
        this.fetchSize = conn.getConfiguration().getFetchSize();
    }

    protected CassandraConfiguration getConfiguration() {
        return this._connection.getConfiguration();
    }

    protected abstract CassandraDataTypeMappings getDataTypeMappings();

    protected abstract CassandraDataTypeConverters getDataTypeConverters();

    protected String getCursorName() {
        return this._cursorName;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.validateState();
        this.batch.add(CassandraCqlParser.parse(this.getConfiguration(), sql));
    }

    @Override
    public void cancel() throws SQLException {
        this.validateState();
    }

    @Override
    public void clearBatch() throws SQLException {
        this.validateState();
        this.batch.clear();
    }

    @Override
    public void close() throws SQLException {
        this._connection = null;
        super.close();
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.validateState();
        this._closeOnCompletion = true;
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.validateState();
        return this._connection;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.validateState();
        return 1000;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.validateState();
        return this.getConfiguration().getFetchSize();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.validateState();
        return null;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.validateState();
        return this.maxFieldSize;
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.validateState();
        return this.maxRows;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.validateState();
        return false;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.validateState();
        return false;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.validateState();
        return this.queryTimeout;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.validateState();
        return 1007;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.validateState();
        return 1;
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.validateState();
        return 1003;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        this.validateState();
        return this._closeOnCompletion;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.validateState();
        return this.poolable;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.validateState();
        this._cursorName = name;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.validateState();
        this.escapeProcessing = enable;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.validateState();
        if (direction != 1000 && !this.quiet) {
            throw CassandraErrors.notSupportedException();
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.validateState();
        this.fetchSize = rows;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.validateState();
        this.maxFieldSize = max;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.validateState();
        this.maxRows = max;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.validateState();
        this.poolable = poolable;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.validateState();
        this.queryTimeout = seconds;
    }
}

