/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc;

import com.github.cassandra.jdbc.BaseCassandraStatement;
import com.github.cassandra.jdbc.BaseJdbcObject;
import com.github.cassandra.jdbc.CassandraCqlStatement;
import com.github.cassandra.jdbc.CassandraDataTypeConverters;
import com.github.cassandra.jdbc.CassandraDataTypeMappings;
import com.github.cassandra.jdbc.CassandraErrors;
import com.github.cassandra.jdbc.CassandraResultSetMetaData;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public abstract class BaseCassandraResultSet
extends BaseJdbcObject
implements ResultSet {
    private boolean _exhausted;
    private int _rowIndex;
    protected final CassandraResultSetMetaData metadata = new CassandraResultSetMetaData();
    protected final BaseCassandraStatement statement;
    protected final CassandraCqlStatement cqlStmt;
    protected final int maxRows;
    protected final int maxFieldSize;
    protected boolean wasNull;

    protected BaseCassandraResultSet(BaseCassandraStatement statement, CassandraCqlStatement cqlStmt) {
        super(statement == null || statement.quiet);
        this.statement = statement;
        this.cqlStmt = cqlStmt;
        this.wasNull = false;
        this.maxRows = statement == null ? 0 : statement.maxRows;
        this.maxFieldSize = statement == null ? 0 : statement.maxFieldSize;
        this._rowIndex = 0;
        this._exhausted = false;
    }

    protected CassandraDataTypeConverters getDataTypeConverters() {
        return this.statement == null ? CassandraDataTypeConverters.instance : this.statement.getDataTypeConverters();
    }

    protected CassandraDataTypeMappings getDataTypeMappings() {
        return this.statement == null ? CassandraDataTypeMappings.instance : this.statement.getDataTypeMappings();
    }

    protected int getCurrentRowIndex() {
        return this._rowIndex;
    }

    protected abstract <T> T getValue(int var1, Class<T> var2) throws SQLException;

    protected abstract boolean hasMore();

    protected void requestColumnAccess(int columnIndex) throws SQLException {
        if (columnIndex < 1) {
            throw new SQLException("Column index starts from one and must be positive");
        }
        if (columnIndex > this.metadata.getColumnCount()) {
            throw new SQLException("We only have " + this.metadata.getColumnCount() + " columns but you're trying to get " + columnIndex);
        }
    }

    protected void requestReadAccess(boolean random) throws SQLException {
        int type = this.getType();
        if (random && type == 1003) {
            throw CassandraErrors.notSupportedException();
        }
    }

    protected void requestWriteAccess() throws SQLException {
        int concurrency = this.getConcurrency();
        if (concurrency == 1007) {
            throw CassandraErrors.notSupportedException();
        }
    }

    protected abstract <T> void setValue(int var1, T var2) throws SQLException;

    protected abstract boolean tryIterate() throws SQLException;

    protected abstract boolean tryMoveTo(int var1, boolean var2) throws SQLException;

    protected void updateCursorState(int rowIndex) {
        if (this._exhausted) {
            if (rowIndex > this._rowIndex) {
                this._rowIndex = rowIndex;
                this._exhausted = false;
            }
        } else if (rowIndex < 0) {
            this._rowIndex = -1;
            this._exhausted = true;
        }
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.requestReadAccess(true);
        return this.tryMoveTo(row, false);
    }

    @Override
    public void afterLast() throws SQLException {
        this.requestReadAccess(true);
        this.tryMoveTo(-1, false);
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.requestReadAccess(true);
        this.tryMoveTo(0, false);
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.requestWriteAccess();
    }

    @Override
    public void close() throws SQLException {
        super.close();
        this.metadata.clear();
        if (this.statement != null && !this.statement.isClosed() && this.statement.isCloseOnCompletion()) {
            this.statement.close();
        }
    }

    @Override
    public void deleteRow() throws SQLException {
        this.requestWriteAccess();
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        return this.metadata.getColumnIndex(columnLabel) + 1;
    }

    @Override
    public boolean first() throws SQLException {
        this.requestReadAccess(true);
        return this.tryMoveTo(1, false);
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        this.requestColumnAccess(columnIndex);
        this.requestReadAccess(false);
        return this.getValue(columnIndex, Array.class);
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        return this.getArray(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        this.requestColumnAccess(columnIndex);
        this.requestReadAccess(false);
        return this.getValue(columnIndex, InputStream.class);
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.requestColumnAccess(columnIndex);
        this.requestReadAccess(false);
        return this.getValue(columnIndex, BigDecimal.class);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        BigDecimal result = this.getBigDecimal(columnIndex);
        if (result != null) {
            result.setScale(scale);
        }
        return result;
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel), scale);
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.requestColumnAccess(columnIndex);
        this.requestReadAccess(false);
        return this.getValue(columnIndex, InputStream.class);
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnLabel));
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        this.requestColumnAccess(columnIndex);
        this.requestReadAccess(false);
        return this.getValue(columnIndex, Blob.class);
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        return this.getBlob(this.findColumn(columnLabel));
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        this.requestColumnAccess(columnIndex);
        this.requestReadAccess(false);
        return this.getValue(columnIndex, Boolean.class);
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        return this.getBoolean(this.findColumn(columnLabel));
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        this.requestColumnAccess(columnIndex);
        this.requestReadAccess(false);
        return this.getValue(columnIndex, Byte.class);
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        return this.getByte(this.findColumn(columnLabel));
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.requestColumnAccess(columnIndex);
        this.requestReadAccess(false);
        return this.getValue(columnIndex, byte[].class);
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        return this.getBytes(this.findColumn(columnLabel));
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        this.requestColumnAccess(columnIndex);
        this.requestReadAccess(false);
        return this.getValue(columnIndex, Reader.class);
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnLabel));
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        this.requestColumnAccess(columnIndex);
        this.requestReadAccess(false);
        return this.getValue(columnIndex, Clob.class);
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        return this.getClob(this.findColumn(columnLabel));
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.validateState();
        return this.statement == null ? 1007 : this.statement.getResultSetConcurrency();
    }

    @Override
    public String getCursorName() throws SQLException {
        this.validateState();
        return this.statement == null ? "cursor@" : this.statement.getCursorName();
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        this.requestColumnAccess(columnIndex);
        this.requestReadAccess(false);
        return this.getValue(columnIndex, Date.class);
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        Date result = this.getDate(columnIndex);
        if (result == null || cal != null) {
            // empty if block
        }
        return result;
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        return this.getDate(this.findColumn(columnLabel));
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnLabel), cal);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.requestColumnAccess(columnIndex);
        this.requestReadAccess(false);
        return this.getValue(columnIndex, Double.class);
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return this.getDouble(this.findColumn(columnLabel));
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.validateState();
        return this.statement == null ? 1000 : this.statement.getFetchDirection();
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.validateState();
        return this.statement == null ? 0 : this.statement.getFetchSize();
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.requestColumnAccess(columnIndex);
        this.requestReadAccess(false);
        return this.getValue(columnIndex, Float.class).floatValue();
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return this.getFloat(this.findColumn(columnLabel));
    }

    @Override
    public int getHoldability() throws SQLException {
        this.validateState();
        return this.statement == null ? 1 : this.statement.getResultSetHoldability();
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.requestColumnAccess(columnIndex);
        this.requestReadAccess(false);
        return this.getValue(columnIndex, Integer.class);
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        return this.getInt(this.findColumn(columnLabel));
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.requestColumnAccess(columnIndex);
        this.requestReadAccess(false);
        return this.getValue(columnIndex, Long.class);
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return this.getLong(this.findColumn(columnLabel));
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.metadata;
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        this.requestColumnAccess(columnIndex);
        this.requestReadAccess(false);
        return this.getValue(columnIndex, Reader.class);
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return this.getNCharacterStream(this.findColumn(columnLabel));
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        this.requestColumnAccess(columnIndex);
        this.requestReadAccess(false);
        return this.getValue(columnIndex, NClob.class);
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        return this.getNClob(this.findColumn(columnLabel));
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.getString(columnIndex);
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this.getNString(this.findColumn(columnLabel));
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.requestColumnAccess(columnIndex);
        this.requestReadAccess(false);
        return this.getValue(columnIndex, Object.class);
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        this.requestColumnAccess(columnIndex);
        this.requestReadAccess(false);
        return this.getValue(columnIndex, type);
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        this.requestColumnAccess(columnIndex);
        this.requestReadAccess(false);
        String cqlTypeName = this.metadata.getColumnTypeName(columnIndex);
        if (map != null && map.containsKey(cqlTypeName)) {
            return this.getValue(columnIndex, map.get(cqlTypeName));
        }
        return this.getValue(columnIndex, Object.class);
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getObject(this.findColumn(columnLabel));
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return this.getObject(this.findColumn(columnLabel), type);
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(this.findColumn(columnLabel), map);
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        this.requestColumnAccess(columnIndex);
        this.requestReadAccess(false);
        return this.getValue(columnIndex, Ref.class);
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        return this.getRef(this.findColumn(columnLabel));
    }

    @Override
    public int getRow() throws SQLException {
        this.validateState();
        if (this._rowIndex < 0) {
            throw new SQLException("Reached end of the result set already");
        }
        return this._rowIndex;
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        this.requestColumnAccess(columnIndex);
        this.requestReadAccess(false);
        return this.getValue(columnIndex, RowId.class);
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        return this.getRowId(this.findColumn(columnLabel));
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        this.requestColumnAccess(columnIndex);
        this.requestReadAccess(false);
        return this.getValue(columnIndex, Short.class);
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return this.getShort(this.findColumn(columnLabel));
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        this.requestColumnAccess(columnIndex);
        this.requestReadAccess(false);
        return this.getValue(columnIndex, SQLXML.class);
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        return this.getSQLXML(this.findColumn(columnLabel));
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.statement;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.requestColumnAccess(columnIndex);
        this.requestReadAccess(false);
        return this.getValue(columnIndex, String.class);
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        return this.getString(this.findColumn(columnLabel));
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        this.requestColumnAccess(columnIndex);
        this.requestReadAccess(false);
        return this.getValue(columnIndex, Time.class);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        Time result = this.getTime(columnIndex);
        if (result == null || cal != null) {
            // empty if block
        }
        return result;
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return this.getTime(this.findColumn(columnLabel));
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnLabel), cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.requestColumnAccess(columnIndex);
        this.requestReadAccess(false);
        return this.getValue(columnIndex, Timestamp.class);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        Timestamp result = this.getTimestamp(columnIndex);
        if (result == null || cal != null) {
            // empty if block
        }
        return result;
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel));
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel), cal);
    }

    @Override
    public int getType() throws SQLException {
        this.validateState();
        return this.statement == null ? 1003 : this.statement.getResultSetType();
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        this.requestColumnAccess(columnIndex);
        this.requestReadAccess(false);
        return this.getValue(columnIndex, InputStream.class);
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnLabel));
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        URL result;
        block5: {
            Object obj = this.getObject(columnIndex);
            result = null;
            if (obj != null) {
                if (obj instanceof URL) {
                    result = (URL)obj;
                } else {
                    try {
                        result = new URL(String.valueOf(obj));
                    }
                    catch (MalformedURLException e) {
                        if (this.quiet) break block5;
                        throw new SQLException(e);
                    }
                }
            }
        }
        return result;
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        return this.getURL(this.findColumn(columnLabel));
    }

    @Override
    public void insertRow() throws SQLException {
        this.requestWriteAccess();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.validateState();
        return this._exhausted && this._rowIndex < 0;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.validateState();
        return !this._exhausted && this._rowIndex == 0;
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.validateState();
        return this._rowIndex == 1;
    }

    @Override
    public boolean isLast() throws SQLException {
        this.validateState();
        return this._exhausted && this._rowIndex >= 0;
    }

    @Override
    public boolean last() throws SQLException {
        this.afterLast();
        return this.tryMoveTo(-1, true);
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.requestWriteAccess();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.requestWriteAccess();
    }

    @Override
    public boolean next() throws SQLException {
        if (this._exhausted) {
            if (this._rowIndex >= 0) {
                this._rowIndex = -1;
            }
            return false;
        }
        boolean movedToNext = this.tryIterate();
        if (movedToNext) {
            ++this._rowIndex;
            this._exhausted = this.maxRows > 0 && this._rowIndex >= this.maxRows || !this.hasMore();
        } else {
            this._exhausted = true;
            this._rowIndex = -1;
        }
        return movedToNext;
    }

    @Override
    public boolean previous() throws SQLException {
        this.requestReadAccess(true);
        return this.tryMoveTo(-1, true);
    }

    @Override
    public void refreshRow() throws SQLException {
        this.requestWriteAccess();
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        this.requestReadAccess(true);
        return this.tryMoveTo(rows, true);
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return false;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return false;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.validateState();
        if (this.statement != null) {
            this.statement.setFetchDirection(direction);
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.validateState();
        if (this.statement != null) {
            this.statement.setFetchSize(rows);
        }
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        this.requestColumnAccess(columnIndex);
        this.requestWriteAccess();
        this.setValue(columnIndex, x);
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        this.updateArray(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        this.updateAsciiStream(columnIndex, x, 0);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.requestColumnAccess(columnIndex);
        this.requestWriteAccess();
        this.setValue(columnIndex, x);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.requestColumnAccess(columnIndex);
        this.requestWriteAccess();
        this.setValue(columnIndex, x);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnLabel), x, length);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnLabel), x, length);
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.requestColumnAccess(columnIndex);
        this.requestWriteAccess();
        this.setValue(columnIndex, x);
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        this.updateBigDecimal(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        this.updateBinaryStream(columnIndex, x, 0);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.requestColumnAccess(columnIndex);
        this.requestWriteAccess();
        this.setValue(columnIndex, x);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.requestColumnAccess(columnIndex);
        this.requestWriteAccess();
        this.setValue(columnIndex, x);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnLabel), x, length);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnLabel), x, length);
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        this.requestColumnAccess(columnIndex);
        this.requestWriteAccess();
        this.setValue(columnIndex, x);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        this.updateBlob(columnIndex, inputStream, 0L);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        this.requestColumnAccess(columnIndex);
        this.requestWriteAccess();
        this.setValue(columnIndex, inputStream);
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        this.updateBlob(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        this.updateBlob(this.findColumn(columnLabel), inputStream);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        this.updateBlob(this.findColumn(columnLabel), inputStream, length);
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.requestColumnAccess(columnIndex);
        this.requestWriteAccess();
        this.setValue(columnIndex, x);
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        this.updateBoolean(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.requestColumnAccess(columnIndex);
        this.requestWriteAccess();
        this.setValue(columnIndex, x);
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        this.updateByte(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.requestColumnAccess(columnIndex);
        this.requestWriteAccess();
        this.setValue(columnIndex, x);
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        this.updateBytes(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.updateCharacterStream(columnIndex, x, 0);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.requestColumnAccess(columnIndex);
        this.requestWriteAccess();
        this.setValue(columnIndex, x);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.requestColumnAccess(columnIndex);
        this.requestWriteAccess();
        this.setValue(columnIndex, x);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnLabel), reader);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnLabel), reader, length);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnLabel), reader, length);
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        this.requestColumnAccess(columnIndex);
        this.requestWriteAccess();
        this.setValue(columnIndex, x);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        this.updateClob(columnIndex, reader, 0L);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.requestColumnAccess(columnIndex);
        this.requestWriteAccess();
        this.setValue(columnIndex, reader);
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        this.updateClob(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        this.updateClob(this.findColumn(columnLabel), reader);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.updateClob(this.findColumn(columnLabel), reader, length);
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        this.requestColumnAccess(columnIndex);
        this.requestWriteAccess();
        this.setValue(columnIndex, x);
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        this.updateDate(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.requestColumnAccess(columnIndex);
        this.requestWriteAccess();
        this.setValue(columnIndex, x);
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        this.updateDouble(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.requestColumnAccess(columnIndex);
        this.requestWriteAccess();
        this.setValue(columnIndex, Float.valueOf(x));
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        this.updateFloat(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        this.requestColumnAccess(columnIndex);
        this.requestWriteAccess();
        this.setValue(columnIndex, x);
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        this.updateInt(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        this.requestColumnAccess(columnIndex);
        this.requestWriteAccess();
        this.setValue(columnIndex, x);
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        this.updateLong(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.updateNCharacterStream(columnIndex, x, 0L);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.requestColumnAccess(columnIndex);
        this.requestWriteAccess();
        this.setValue(columnIndex, x);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.updateNCharacterStream(this.findColumn(columnLabel), reader);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.updateNCharacterStream(this.findColumn(columnLabel), reader, length);
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        this.requestColumnAccess(columnIndex);
        this.requestWriteAccess();
        this.setValue(columnIndex, nClob);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        this.updateNClob(columnIndex, reader, 0L);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.requestColumnAccess(columnIndex);
        this.requestWriteAccess();
        this.setValue(columnIndex, reader);
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        this.updateNClob(this.findColumn(columnLabel), nClob);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        this.updateNClob(this.findColumn(columnLabel), reader);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.updateNClob(this.findColumn(columnLabel), reader, length);
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        this.requestColumnAccess(columnIndex);
        this.requestWriteAccess();
        this.setValue(columnIndex, nString);
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        this.updateNString(this.findColumn(columnLabel), nString);
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        this.requestColumnAccess(columnIndex);
        this.requestWriteAccess();
        this.setValue(columnIndex, null);
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        this.updateNull(this.findColumn(columnLabel));
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.requestColumnAccess(columnIndex);
        this.requestWriteAccess();
        this.setValue(columnIndex, x);
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        this.requestColumnAccess(columnIndex);
        this.requestWriteAccess();
        this.setValue(columnIndex, x);
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        this.updateObject(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        this.updateObject(this.findColumn(columnLabel), x, scaleOrLength);
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        this.requestColumnAccess(columnIndex);
        this.requestWriteAccess();
        this.setValue(columnIndex, x);
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        this.updateRef(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateRow() throws SQLException {
        this.requestWriteAccess();
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        this.requestColumnAccess(columnIndex);
        this.requestWriteAccess();
        this.setValue(columnIndex, x);
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        this.updateRowId(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        this.requestColumnAccess(columnIndex);
        this.requestWriteAccess();
        this.setValue(columnIndex, x);
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        this.updateShort(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        this.requestColumnAccess(columnIndex);
        this.requestWriteAccess();
        this.setValue(columnIndex, xmlObject);
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        this.updateSQLXML(this.findColumn(columnLabel), xmlObject);
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        this.requestColumnAccess(columnIndex);
        this.requestWriteAccess();
        this.setValue(columnIndex, x);
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        this.updateString(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.requestColumnAccess(columnIndex);
        this.requestWriteAccess();
        this.setValue(columnIndex, x);
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        this.updateTime(this.findColumn(columnLabel), x);
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.requestColumnAccess(columnIndex);
        this.requestWriteAccess();
        this.setValue(columnIndex, x);
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        this.updateTimestamp(this.findColumn(columnLabel), x);
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.wasNull;
    }
}

