/*
 * Decompiled with CFR 0.152.
 */
package com.github.cassandra.jdbc;

import com.github.cassandra.jdbc.BaseJdbcObject;
import com.github.cassandra.jdbc.CassandraConfiguration;
import com.github.cassandra.jdbc.CassandraCqlParser;
import com.github.cassandra.jdbc.CassandraCqlStatement;
import com.github.cassandra.jdbc.CassandraDataTypeMappings;
import com.github.cassandra.jdbc.CassandraDatabaseMetaData;
import com.github.cassandra.jdbc.CassandraErrors;
import com.github.cassandra.jdbc.CassandraObjectType;
import com.github.cassandra.jdbc.CassandraUtils;
import com.github.cassandra.jdbc.DummyCassandraResultSet;
import com.github.cassandra.jdbc.internal.google.common.base.Strings;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;

public abstract class BaseCassandraConnection
extends BaseJdbcObject
implements Connection {
    private final Properties _clientInfo = new Properties();
    private int _txIsolationLevel = 0;
    private final Map<String, Class<?>> _typeMap = new HashMap();
    protected final CassandraConfiguration config;
    protected final CassandraDatabaseMetaData metaData;

    public BaseCassandraConnection(CassandraConfiguration driverConfig) {
        super(driverConfig.isQuiet());
        this.config = driverConfig;
        this.metaData = new CassandraDatabaseMetaData(this);
        this.metaData.setProperty("url", driverConfig.getConnectionUrl());
        this.metaData.setProperty("user", driverConfig.getUserName());
    }

    protected abstract <T> T createObject(Class<T> var1) throws SQLException;

    protected ResultSet getObjectMetaData(CassandraObjectType objectType, Properties queryPatterns, Object ... additionalHints) throws SQLException {
        DummyCassandraResultSet rs;
        switch (objectType) {
            case TABLE_TYPE: {
                rs = new DummyCassandraResultSet(CassandraUtils.TABLE_TYPE_COLUMNS, CassandraUtils.TABLE_TYPE_DATA);
                break;
            }
            case TYPE: {
                rs = new DummyCassandraResultSet(CassandraUtils.TYPE_COLUMNS, CassandraDataTypeMappings.instance.getTypeMetaData());
                break;
            }
            default: {
                throw CassandraErrors.notSupportedException();
            }
        }
        return rs;
    }

    public CassandraConfiguration getConfiguration() {
        return this.config;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.validateState();
        if (!this.quiet) {
            throw CassandraErrors.notSupportedException();
        }
    }

    @Override
    public void commit() throws SQLException {
        this.validateState();
        if (!this.quiet) {
            throw CassandraErrors.notSupportedException();
        }
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.validateState();
        Array result = this.createObject(Array.class);
        return result;
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.validateState();
        return this.createObject(Blob.class);
    }

    @Override
    public Clob createClob() throws SQLException {
        this.validateState();
        return this.createObject(Clob.class);
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.validateState();
        return this.createObject(NClob.class);
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.validateState();
        return this.createObject(SQLXML.class);
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createStatement(resultSetType, resultSetConcurrency, 1);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        this.validateState();
        Struct result = this.createObject(Struct.class);
        return result;
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.validateState();
        return this.config.isAutoCommit();
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.validateState();
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this._clientInfo);
        return props;
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.validateState();
        return this._clientInfo.getProperty(name);
    }

    @Override
    public int getHoldability() throws SQLException {
        this.validateState();
        return 1;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.validateState();
        if (!this.quiet && this.metaData == null) {
            throw CassandraErrors.databaseMetaDataNotAvailableException();
        }
        return this.metaData;
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        this.validateState();
        return this.config.getConnectionTimeout();
    }

    @Override
    public String getCatalog() throws SQLException {
        this.validateState();
        return null;
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.validateState();
        return this._txIsolationLevel;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.validateState();
        HashMap map = new HashMap();
        map.putAll(this._typeMap);
        return map;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.validateState();
        return this.config.isReadOnly();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        this.validateState();
        return !this.closed;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.validateState();
        if (this.config.isSqlFriendly()) {
            CassandraCqlStatement stmt = CassandraCqlParser.parse(this.config, sql);
            sql = stmt.getCql();
        }
        return Strings.nullToEmpty(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.prepareCall(sql, 1003, 1007, 1);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareCall(sql, resultSetType, resultSetConcurrency, 1);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.validateState();
        if (!this.quiet) {
            throw CassandraErrors.notSupportedException();
        }
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007, 1);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007, 1);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, 1);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return this.prepareStatement(sql);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.validateState();
        if (!this.quiet) {
            throw CassandraErrors.notSupportedException();
        }
    }

    @Override
    public void rollback() throws SQLException {
        this.validateState();
        if (!this.quiet) {
            throw CassandraErrors.notSupportedException();
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.validateState();
        if (!this.quiet) {
            throw CassandraErrors.notSupportedException();
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.validateState();
        if (!this.quiet && !autoCommit) {
            throw CassandraErrors.notSupportedException();
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this._clientInfo.clear();
        if (properties != null) {
            this._clientInfo.putAll((Map<?, ?>)properties);
        }
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this._clientInfo.setProperty(name, value);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.validateState();
        if (!this.quiet && holdability != 1) {
            throw CassandraErrors.notSupportedException();
        }
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.validateState();
        if (!this.quiet) {
            throw CassandraErrors.notSupportedException();
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.validateState();
        if (!this.quiet) {
            throw CassandraErrors.notSupportedException();
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.setSavepoint(null);
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.validateState();
        if (!this.quiet) {
            throw CassandraErrors.notSupportedException();
        }
        return null;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.validateState();
        this.validateState();
        if (!this.quiet) {
            throw CassandraErrors.notSupportedException();
        }
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.validateState();
        if (!this.quiet && level != 0) {
            throw CassandraErrors.notSupportedException();
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.validateState();
        this._typeMap.clear();
        if (map != null) {
            this._typeMap.putAll(map);
        }
    }
}

