/*
 * Decompiled with CFR 0.152.
 */
package com.xkzhangsan.time.cron;

import com.xkzhangsan.time.cron.CronExpression;
import com.xkzhangsan.time.formatter.DateTimeFormatterUtil;
import com.xkzhangsan.time.utils.CollectionUtil;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class CronExpressionUtil {
    private CronExpressionUtil() {
    }

    public static boolean isValidExpression(String cronExpression) {
        return CronExpression.isValidExpression(cronExpression);
    }

    public static String formatExpression(String cronExpression) {
        try {
            return new CronExpression(cronExpression).toString();
        }
        catch (ParseException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static Date getNextTime(String cronExpression, Date date) {
        try {
            if (date != null) {
                return new CronExpression(cronExpression).getNextValidTimeAfter(date);
            }
            return new CronExpression(cronExpression).getNextValidTimeAfter(new Date());
        }
        catch (ParseException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static Date getNextTime(String cronExpression) {
        return CronExpressionUtil.getNextTime(cronExpression, null);
    }

    public static String getNextTimeStr(String cronExpression, Date date) {
        return DateTimeFormatterUtil.formatToDateTimeStr(CronExpressionUtil.getNextTime(cronExpression, date));
    }

    public static String getNextTimeStr(String cronExpression) {
        return CronExpressionUtil.getNextTimeStr(cronExpression, null);
    }

    public static List<Date> getNextTimeList(String cronExpression, Date date, int num) {
        ArrayList<Date> dateList = new ArrayList<Date>();
        if (num < 1) {
            throw new RuntimeException("num must be greater than 0");
        }
        Date startDate = date != null ? date : new Date();
        for (int i = 0; i < num; ++i) {
            if ((startDate = CronExpressionUtil.getNextTime(cronExpression, startDate)) == null) continue;
            dateList.add(startDate);
        }
        return dateList;
    }

    public static List<Date> getNextTimeList(String cronExpression, int num) {
        return CronExpressionUtil.getNextTimeList(cronExpression, null, num);
    }

    public static List<String> getNextTimeStrList(String cronExpression, Date date, int num) {
        ArrayList<String> dateStrList = new ArrayList<String>();
        List<Date> dateList = CronExpressionUtil.getNextTimeList(cronExpression, date, num);
        if (CollectionUtil.isNotEmpty(dateList)) {
            dateList.stream().forEach(d -> {
                String dateStr = DateTimeFormatterUtil.formatToDateTimeStr(d);
                dateStrList.add(dateStr);
            });
        }
        return dateStrList;
    }

    public static List<String> getNextTimeStrList(String cronExpression, int num) {
        return CronExpressionUtil.getNextTimeStrList(cronExpression, null, num);
    }

    public static boolean isSatisfiedBy(String cronExpression, Date date) {
        try {
            return new CronExpression(cronExpression).isSatisfiedBy(date);
        }
        catch (ParseException e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

