/*
 * Decompiled with CFR 0.152.
 */
package com.github.wvengen.maven.proguard;

import com.github.wvengen.maven.proguard.Assembly;
import com.github.wvengen.maven.proguard.Exclusion;
import com.github.wvengen.maven.proguard.Inclusion;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Java;
import org.codehaus.plexus.archiver.jar.JarArchiver;

public class ProGuardMojo
extends AbstractMojo {
    private boolean skip;
    private File proguardInclude;
    private String proguardVersion;
    private boolean useDexGuard;
    private String[] options;
    private boolean obfuscate;
    private boolean includeDependency;
    private File tempLibraryjarsDir;
    private boolean putLibraryJarsInTempDir;
    private boolean generateTemporaryConfigurationFile;
    private File temporaryConfigurationFile;
    private boolean includeDependencyInjar;
    private Assembly assembly;
    private List<String> libs;
    private List<Exclusion> exclusions;
    protected String injar;
    private boolean injarNotExistsSkip;
    protected String inFilter;
    protected String inLibsFilter;
    protected String outjar;
    protected String outFilter;
    private boolean attach;
    private boolean attachMap;
    private boolean attachSeed;
    private String attachArtifactType;
    private String attachArtifactClassifier;
    private boolean appendClassifier;
    private boolean addMavenDescriptor;
    protected File outputDirectory;
    protected MavenProject mavenProject;
    protected List<Artifact> pluginArtifacts;
    private MavenProjectHelper projectHelper;
    private JarArchiver jarArchiver;
    protected MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    protected String maxMemory;
    protected String proguardMainClass = "proguard.ProGuard";
    protected String mappingFileName = "proguard_map.txt";
    protected String seedFileName = "proguard_seeds.txt";
    protected File applyMappingFile;
    private boolean incremental;
    protected File proguardJar;
    private boolean silent;
    private Log log;

    private String fileNameToString(String fileName) {
        return "'" + fileName + "'";
    }

    private String fileToString(File file) {
        return this.fileNameToString(file.toString());
    }

    private String libFileToStringWithInLibsFilter(File file) {
        return this.libFileToStringWithInLibsFilter(file.toString());
    }

    private String libFileToStringWithInLibsFilter(String file) {
        StringBuilder filter = new StringBuilder(this.fileNameToString(file));
        if (this.inLibsFilter != null) {
            filter.append("(").append(this.inLibsFilter).append(")");
        }
        return filter.toString();
    }

    private boolean useArtifactClassifier() {
        return this.appendClassifier && this.attachArtifactClassifier != null && this.attachArtifactClassifier.length() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        Object filter;
        File outJarFile;
        boolean sameArtifact;
        this.log = this.getLog();
        if (this.skip) {
            this.log.info((CharSequence)"Bypass ProGuard processing because \"proguard.skip=true\"");
            return;
        }
        boolean mainIsJar = this.mavenProject.getPackaging().equals("jar");
        File inJarFile = new File(this.outputDirectory, this.injar);
        if (!inJarFile.exists()) {
            if (this.injarNotExistsSkip) {
                this.log.info((CharSequence)"Bypass ProGuard processing because \"injar\" dos not exist");
                return;
            }
            if (mainIsJar) {
                throw new MojoFailureException("Can't find file " + inJarFile);
            }
        }
        if (!this.outputDirectory.exists() && !this.outputDirectory.mkdirs()) {
            throw new MojoFailureException("Can't create " + this.outputDirectory);
        }
        if (this.attach) {
            this.outjar = this.nameNoType(this.injar);
            if (this.useArtifactClassifier()) {
                this.outjar = this.outjar + "-" + this.attachArtifactClassifier;
            }
            this.outjar = this.outjar + "." + this.attachArtifactType;
        }
        if (this.outjar != null && !this.outjar.equals(this.injar)) {
            sameArtifact = false;
            outJarFile = new File(this.outputDirectory, this.outjar).getAbsoluteFile();
            if (outJarFile.exists() && !this.deleteFileOrDirectory(outJarFile)) {
                throw new MojoFailureException("Can't delete " + outJarFile);
            }
        } else {
            sameArtifact = true;
            outJarFile = inJarFile.getAbsoluteFile();
            File baseFile = inJarFile.isDirectory() ? new File(this.outputDirectory, this.nameNoType(this.injar) + "_proguard_base") : new File(this.outputDirectory, this.nameNoType(this.injar) + "_proguard_base.jar");
            if (baseFile.exists() && !this.deleteFileOrDirectory(baseFile)) {
                throw new MojoFailureException("Can't delete " + baseFile);
            }
            if (inJarFile.exists() && !inJarFile.renameTo(baseFile)) {
                throw new MojoFailureException("Can't rename " + inJarFile);
            }
            inJarFile = baseFile;
        }
        ArrayList<String> args = new ArrayList<String>();
        ArrayList<File> libraryJars = new ArrayList<File>();
        if (this.log.isDebugEnabled()) {
            List dependancy = this.mavenProject.getCompileArtifacts();
            for (Object artifact : dependancy) {
                this.log.debug((CharSequence)("--- compile artifact " + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getType() + ":" + artifact.getClassifier() + " Scope:" + artifact.getScope()));
            }
            Set artifacts = this.mavenProject.getArtifacts();
            for (Object artifact : artifacts) {
                this.log.debug((CharSequence)("--- artifact " + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getType() + ":" + artifact.getClassifier() + " Scope:" + artifact.getScope()));
            }
            List dependencies = this.mavenProject.getDependencies();
            for (Object artifact : dependencies) {
                this.log.debug((CharSequence)("--- dependency " + artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getType() + ":" + artifact.getClassifier() + " Scope:" + artifact.getScope()));
            }
        }
        HashSet<String> inPath = new HashSet<String>();
        HashMap<Artifact, Inclusion> injars = new HashMap<Artifact, Inclusion>();
        HashMap<Artifact, Inclusion> libraryjars = new HashMap<Artifact, Inclusion>();
        boolean hasInclusionLibrary = false;
        if (this.assembly != null && this.assembly.inclusions != null) {
            File file;
            for (Inclusion inclusion : this.assembly.inclusions) {
                for (Artifact artifact : this.getDependencies(inclusion, this.mavenProject)) {
                    if (inclusion.library) {
                        if (injars.containsKey(artifact)) continue;
                        libraryjars.put(artifact, inclusion);
                        continue;
                    }
                    injars.put(artifact, inclusion);
                    if (!libraryjars.containsKey(artifact)) continue;
                    libraryjars.remove(artifact);
                }
            }
            for (Map.Entry entry : injars.entrySet()) {
                this.log.info((CharSequence)("--- ADD injars:" + ((Artifact)entry.getKey()).getArtifactId()));
                file = this.getClasspathElement((Artifact)entry.getKey(), this.mavenProject);
                inPath.add(file.toString());
                StringBuilder filter2 = new StringBuilder(this.fileToString(file));
                filter2.append("(!META-INF/MANIFEST.MF");
                if (!this.addMavenDescriptor) {
                    filter2.append(",");
                    filter2.append("!META-INF/maven/**");
                }
                if (((Inclusion)entry.getValue()).filter != null) {
                    filter2.append(",").append(((Inclusion)entry.getValue()).filter);
                }
                filter2.append(")");
                args.add("-injars");
                args.add(filter2.toString());
            }
            for (Map.Entry entry : libraryjars.entrySet()) {
                this.log.info((CharSequence)("--- ADD libraryjars:" + ((Artifact)entry.getKey()).getArtifactId()));
                file = this.getClasspathElement((Artifact)entry.getKey(), this.mavenProject);
                hasInclusionLibrary = true;
                inPath.add(file.toString());
                if (this.putLibraryJarsInTempDir) {
                    libraryJars.add(file);
                    continue;
                }
                args.add("-libraryjars");
                args.add(this.libFileToStringWithInLibsFilter(file));
            }
        }
        if (inJarFile.exists()) {
            args.add("-injars");
            filter = new StringBuilder(this.fileToString(inJarFile));
            if (this.inFilter != null || !this.addMavenDescriptor) {
                boolean bl;
                ((StringBuilder)filter).append("(");
                boolean bl2 = false;
                if (!this.addMavenDescriptor) {
                    bl = true;
                    ((StringBuilder)filter).append("!META-INF/maven/**");
                }
                if (this.inFilter != null) {
                    if (bl) {
                        ((StringBuilder)filter).append(",");
                    }
                    ((StringBuilder)filter).append(this.inFilter);
                }
                ((StringBuilder)filter).append(")");
            }
            args.add(((StringBuilder)filter).toString());
        }
        if (this.includeDependency) {
            List dependency = this.mavenProject.getCompileArtifacts();
            for (Object artifact : dependency) {
                if (this.isExclusion((Artifact)artifact)) continue;
                File file = this.getClasspathElement((Artifact)artifact, this.mavenProject);
                if (inPath.contains(file.toString())) {
                    this.log.debug((CharSequence)("--- ignore library since one in injar:" + artifact.getArtifactId()));
                    continue;
                }
                if (this.includeDependencyInjar) {
                    this.log.debug((CharSequence)("--- ADD library as injars:" + artifact.getArtifactId()));
                    args.add("-injars");
                    args.add(this.fileToString(file));
                    continue;
                }
                this.log.debug((CharSequence)("--- ADD libraryjars:" + artifact.getArtifactId()));
                if (this.putLibraryJarsInTempDir) {
                    libraryJars.add(file);
                    continue;
                }
                args.add("-libraryjars");
                args.add(this.libFileToStringWithInLibsFilter(file));
            }
        }
        if (args.contains("-injars")) {
            args.add("-outjars");
            filter = new StringBuilder(this.fileToString(outJarFile));
            if (this.outFilter != null) {
                ((StringBuilder)filter).append("(").append(this.outFilter).append(")");
            }
            args.add(((StringBuilder)filter).toString());
        }
        if (!this.obfuscate) {
            args.add("-dontobfuscate");
        }
        if (this.proguardInclude != null) {
            if (this.proguardInclude.exists()) {
                args.add("-include");
                args.add(this.fileToString(this.proguardInclude));
                this.log.debug((CharSequence)("proguardInclude " + this.proguardInclude));
            } else {
                this.log.debug((CharSequence)("proguardInclude config does not exists " + this.proguardInclude));
            }
        }
        if (this.libs != null) {
            for (String string : this.libs) {
                if (this.putLibraryJarsInTempDir) {
                    libraryJars.add(new File(string));
                    continue;
                }
                args.add("-libraryjars");
                args.add(this.libFileToStringWithInLibsFilter(string));
            }
        }
        if (!libraryJars.isEmpty()) {
            this.log.debug((CharSequence)"Copy libraryJars to temporary directory");
            this.log.debug((CharSequence)("Temporary directory: " + this.tempLibraryjarsDir));
            if (this.tempLibraryjarsDir.exists()) {
                try {
                    FileUtils.deleteDirectory((File)this.tempLibraryjarsDir);
                }
                catch (IOException ignored) {
                    throw new MojoFailureException("Deleting failed libraryJars directory", (Throwable)ignored);
                }
            }
            this.tempLibraryjarsDir.mkdir();
            if (!this.tempLibraryjarsDir.exists()) {
                throw new MojoFailureException("Can't create temporary libraryJars directory: " + this.tempLibraryjarsDir.getAbsolutePath());
            }
            File commonDir = new File(this.tempLibraryjarsDir, "0");
            commonDir.mkdir();
            boolean bl = true;
            for (File libraryJar : libraryJars) {
                void var12_24;
                try {
                    this.log.debug((CharSequence)("Copying library: " + libraryJar));
                    if (libraryJar.isFile()) {
                        FileUtils.copyFileToDirectory((File)libraryJar, (File)commonDir);
                    } else {
                        File subDir = new File(this.tempLibraryjarsDir, String.valueOf((int)var12_24));
                        FileUtils.copyDirectory((File)libraryJar, (File)subDir);
                        args.add("-libraryjars");
                        args.add(this.libFileToStringWithInLibsFilter(subDir));
                    }
                }
                catch (IOException e) {
                    throw new MojoFailureException("Can't copy to temporary libraryJars directory", (Throwable)e);
                }
                ++var12_24;
            }
            args.add("-libraryjars");
            args.add(this.libFileToStringWithInLibsFilter(commonDir));
        }
        File mappingFile = new File(this.outputDirectory, this.mappingFileName);
        args.add("-printmapping");
        args.add(this.fileToString(mappingFile.getAbsoluteFile()));
        args.add("-printseeds");
        args.add(this.fileToString(new File(this.outputDirectory, this.seedFileName).getAbsoluteFile()));
        if (this.incremental && this.applyMappingFile == null) {
            throw new MojoFailureException("applyMappingFile is required if incremental is true");
        }
        if (this.applyMappingFile != null && (!this.incremental || this.applyMappingFile.exists())) {
            args.add("-applymapping");
            args.add(this.fileToString(this.applyMappingFile.getAbsoluteFile()));
        }
        if (this.log.isDebugEnabled()) {
            args.add("-verbose");
        }
        if (this.options != null) {
            Collections.addAll(args, this.options);
        }
        if (this.generateTemporaryConfigurationFile) {
            this.log.info((CharSequence)"building config file");
            StringBuilder stringBuilder = new StringBuilder();
            for (String arg : args) {
                if (arg.startsWith("-")) {
                    stringBuilder.append("\n");
                } else {
                    stringBuilder.append(" ");
                }
                stringBuilder.append(arg);
            }
            try (FileWriter writer = new FileWriter(this.temporaryConfigurationFile);){
                IOUtils.write((String)stringBuilder.toString(), (Writer)writer);
            }
            catch (IOException e) {
                throw new MojoFailureException("cannot write to temporary configuration file " + this.temporaryConfigurationFile, (Throwable)e);
            }
            args = new ArrayList();
            args.add("-include");
            args.add(this.fileToString(this.temporaryConfigurationFile));
        }
        this.log.info((CharSequence)("execute ProGuard " + args.toString()));
        this.proguardMain(this.getProguardJars(this), args, this);
        if (!libraryJars.isEmpty()) {
            this.deleteFileOrDirectory(this.tempLibraryjarsDir);
        }
        if (this.assembly != null && hasInclusionLibrary) {
            this.log.info((CharSequence)"creating assembly");
            File file = new File(this.outputDirectory, this.nameNoType(this.injar) + "_proguard_result.jar");
            if (file.exists() && !file.delete()) {
                throw new MojoFailureException("Can't delete " + file);
            }
            File archiverFile = outJarFile.getAbsoluteFile();
            if (!outJarFile.renameTo(file)) {
                throw new MojoFailureException("Can't rename " + outJarFile);
            }
            MavenArchiver archiver = new MavenArchiver();
            archiver.setArchiver(this.jarArchiver);
            archiver.setOutputFile(archiverFile);
            this.archive.setAddMavenDescriptor(this.addMavenDescriptor);
            try {
                this.jarArchiver.addArchivedFileSet(file);
                for (Map.Entry entry : libraryjars.entrySet()) {
                    File file2 = this.getClasspathElement((Artifact)entry.getKey(), this.mavenProject);
                    if (file2.isDirectory()) {
                        this.getLog().info((CharSequence)("merge project: " + entry.getKey() + " " + file2));
                        this.jarArchiver.addDirectory(file2);
                        continue;
                    }
                    this.getLog().info((CharSequence)("merge artifact: " + entry.getKey()));
                    String filter3 = ((Inclusion)entry.getValue()).filter;
                    if (filter3 == null) {
                        this.jarArchiver.addArchivedFileSet(file2);
                        continue;
                    }
                    ArrayList<String> includes = new ArrayList<String>();
                    ArrayList<String> excludes = new ArrayList<String>();
                    for (String element : filter3.split(",")) {
                        if (element.startsWith("!")) {
                            excludes.add(element.substring(1));
                            continue;
                        }
                        includes.add(element);
                    }
                    this.jarArchiver.addArchivedFileSet(file2, includes.isEmpty() ? null : includes.toArray(new String[0]), excludes.isEmpty() ? null : excludes.toArray(new String[0]));
                }
                archiver.createArchive(this.mavenProject, this.archive);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Unable to create jar", e);
            }
        }
        if (this.incremental) {
            this.log.info((CharSequence)("Merging mapping file into " + this.applyMappingFile));
            try (FileInputStream fileInputStream = new FileInputStream(mappingFile);){
                this.applyMappingFile.getParentFile().mkdirs();
                try (FileOutputStream mappingFileOut = new FileOutputStream(this.applyMappingFile, true);){
                    IOUtils.copy((InputStream)fileInputStream, (OutputStream)mappingFileOut);
                }
            }
            catch (IOException iOException) {
                throw new MojoExecutionException("Unable to merge mapping file", (Exception)iOException);
            }
        }
        if (this.attach) {
            if (!sameArtifact) {
                void var12_31;
                if (this.useArtifactClassifier()) {
                    String string = this.attachArtifactClassifier;
                } else {
                    Object var12_30 = null;
                }
                this.projectHelper.attachArtifact(this.mavenProject, this.attachArtifactType, (String)var12_31, outJarFile);
            }
            String string = this.useArtifactClassifier() ? this.attachArtifactClassifier : null;
            File buildOutput = new File(this.mavenProject.getBuild().getDirectory());
            if (this.attachMap) {
                this.attachTextFile(new File(buildOutput, this.mappingFileName), string, "map");
            }
            if (this.attachSeed) {
                this.attachTextFile(new File(buildOutput, this.seedFileName), string, "seed");
            }
        }
    }

    private void attachTextFile(File theFile, String mainClassifier, String suffix) {
        String classifier = (null == mainClassifier ? "" : mainClassifier + "-") + suffix;
        this.log.info((CharSequence)("Attempting to attach " + suffix + " artifact"));
        if (theFile.exists()) {
            if (theFile.isFile()) {
                this.projectHelper.attachArtifact(this.mavenProject, "txt", classifier, theFile);
            } else {
                this.log.warn((CharSequence)("Cannot attach file because it is not a file: " + theFile));
            }
        } else {
            this.log.warn((CharSequence)("Cannot attach file because it does not exist: " + theFile));
        }
    }

    private Set<File> getAllPluginArtifactDependencies(ProGuardMojo mojo) throws MojoExecutionException {
        HashSet<File> files = new HashSet<File>(this.getProguardJars(mojo));
        for (Artifact artifact : mojo.pluginArtifacts) {
            files.add(artifact.getFile().getAbsoluteFile());
            files.addAll(this.getChildArtifacts(artifact));
        }
        return files;
    }

    private Set<File> getChildArtifacts(Artifact artifact) {
        HashSet<File> files = new HashSet<File>();
        for (Object child : artifact.getDependencyTrail()) {
            if (!(child instanceof Artifact)) continue;
            files.add(((Artifact)child).getFile().getAbsoluteFile());
            files.addAll(this.getChildArtifacts((Artifact)child));
        }
        return files;
    }

    private List<File> getProguardJars(ProGuardMojo mojo) throws MojoExecutionException {
        if (this.proguardJar != null) {
            if (this.proguardJar.exists()) {
                if (this.proguardJar.isFile()) {
                    return Collections.singletonList(this.proguardJar);
                }
                mojo.getLog().warn((CharSequence)("proguard jar (" + this.proguardJar + ") is not a file"));
                throw new MojoExecutionException("proguard jar (" + this.proguardJar + ") is not a file");
            }
            mojo.getLog().warn((CharSequence)("proguard jar (" + this.proguardJar + ") does not exist"));
            throw new MojoExecutionException("proguard jar (" + this.proguardJar + ") does not exist");
        }
        ArrayList<Artifact> proguardArtifacts = new ArrayList<Artifact>();
        int proguardArtifactDistance = -1;
        for (Artifact artifact : mojo.pluginArtifacts) {
            mojo.getLog().debug((CharSequence)("pluginArtifact: " + artifact.getFile()));
            String string = artifact.getArtifactId();
            if (!string.startsWith(this.useDexGuard ? "dexguard" : "proguard") || string.startsWith("proguard-maven-plugin")) continue;
            int distance = artifact.getDependencyTrail().size();
            mojo.getLog().debug((CharSequence)("proguard DependencyTrail: " + distance));
            if (mojo.proguardVersion != null && !mojo.proguardVersion.equals(artifact.getVersion())) continue;
            for (Artifact artifact2 : proguardArtifacts) {
                if (!artifact2.getArtifactId().equals(string)) continue;
                mojo.getLog().warn((CharSequence)("Dependency for proguard defined twice! This may lead to unexpected results: " + artifact2.getArtifactId() + ":" + artifact2.getVersion() + " | " + string + ":" + artifact.getVersion()));
                break;
            }
            if (mojo.proguardVersion != null && mojo.proguardVersion.equals(artifact.getVersion())) {
                proguardArtifacts.add(artifact);
                continue;
            }
            if (proguardArtifactDistance == -1) {
                proguardArtifacts.add(artifact);
                proguardArtifactDistance = distance;
                continue;
            }
            if (distance > proguardArtifactDistance) continue;
            Iterator it = proguardArtifacts.iterator();
            while (it.hasNext()) {
                Artifact artifact3 = (Artifact)it.next();
                if (distance >= artifact3.getDependencyTrail().size()) continue;
                it.remove();
            }
            proguardArtifacts.add(artifact);
            proguardArtifactDistance = distance;
        }
        if (!proguardArtifacts.isEmpty()) {
            ArrayList<File> resList = new ArrayList<File>(proguardArtifacts.size());
            for (Artifact artifact : proguardArtifacts) {
                mojo.getLog().debug((CharSequence)("proguardArtifact: " + artifact.getFile()));
                resList.add(artifact.getFile().getAbsoluteFile());
            }
            return resList;
        }
        mojo.getLog().info((CharSequence)((this.useDexGuard ? "dexguard" : "proguard") + " jar not found in pluginArtifacts"));
        ClassLoader cl = ((Object)((Object)mojo)).getClass().getClassLoader();
        String string = "/" + mojo.proguardMainClass.replace('.', '/') + ".class";
        URL uRL = cl.getResource(string);
        if (uRL == null) {
            throw new MojoExecutionException("Obfuscation failed ProGuard (" + mojo.proguardMainClass + ") not found in classpath");
        }
        String proguardJar = uRL.toExternalForm();
        if (!proguardJar.startsWith("jar:file:")) {
            throw new MojoExecutionException("Unrecognized location (" + proguardJar + ") in classpath");
        }
        proguardJar = proguardJar.substring("jar:file:".length());
        proguardJar = proguardJar.substring(0, proguardJar.indexOf(33));
        return Collections.singletonList(new File(proguardJar));
    }

    private void proguardMain(Collection<File> proguardJars, List<String> argsList, ProGuardMojo mojo) throws MojoExecutionException {
        Java java = new Java();
        Project antProject = new Project();
        antProject.setName(mojo.mavenProject.getName());
        antProject.init();
        DefaultLogger antLogger = new DefaultLogger();
        antLogger.setOutputPrintStream(System.out);
        antLogger.setErrorPrintStream(System.err);
        int logLevel = mojo.log.isDebugEnabled() ? 4 : 2;
        antLogger.setMessageOutputLevel(this.silent ? 0 : logLevel);
        antProject.addBuildListener((BuildListener)antLogger);
        antProject.setBaseDir(mojo.mavenProject.getBasedir());
        java.setProject(antProject);
        java.setTaskName("proguard");
        mojo.getLog().info((CharSequence)("proguard jar: " + proguardJars));
        Set<File> allDependencyFiles = this.getAllPluginArtifactDependencies(mojo);
        for (File p : allDependencyFiles) {
            java.createClasspath().createPathElement().setLocation(p);
        }
        java.setClassname(mojo.proguardMainClass);
        java.setFailonerror(true);
        java.setFork(true);
        if (mojo.maxMemory != null) {
            java.setMaxmemory(mojo.maxMemory);
        }
        for (String arg : argsList) {
            java.createArg().setValue(arg);
        }
        int result = java.executeJava();
        if (result != 0) {
            throw new MojoExecutionException("Obfuscation failed (result=" + result + ")");
        }
    }

    private String nameNoType(String fileName) {
        int extStart = fileName.lastIndexOf(46);
        if (extStart == -1) {
            return fileName;
        }
        return fileName.substring(0, extStart);
    }

    private boolean deleteFileOrDirectory(File path) throws MojoFailureException {
        if (path.isDirectory()) {
            File[] files = path.listFiles();
            if (null != files) {
                for (File file : files) {
                    if (file.isDirectory()) {
                        if (this.deleteFileOrDirectory(file)) continue;
                        throw new MojoFailureException("Can't delete dir " + file);
                    }
                    if (file.delete()) continue;
                    throw new MojoFailureException("Can't delete file " + file);
                }
            }
            return path.delete();
        }
        return path.delete();
    }

    private Set<Artifact> getDependencies(Inclusion inc, MavenProject mavenProject) throws MojoExecutionException {
        Set dependencies = mavenProject.getArtifacts();
        HashSet<Artifact> result = new HashSet<Artifact>();
        for (Artifact artifact : dependencies) {
            if (!inc.match(artifact)) continue;
            result.add(artifact);
        }
        if (result.isEmpty()) {
            this.log.warn((CharSequence)String.format("No artifact found : %s:%s", inc.artifactId, inc.groupId));
        }
        return result;
    }

    private boolean isExclusion(Artifact artifact) {
        if (this.exclusions == null) {
            return false;
        }
        for (Exclusion excl : this.exclusions) {
            if (!excl.match(artifact)) continue;
            return true;
        }
        return false;
    }

    private File getClasspathElement(Artifact artifact, MavenProject mavenProject) throws MojoExecutionException {
        if (artifact.getClassifier() != null) {
            return artifact.getFile();
        }
        String refId = artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion();
        MavenProject project = (MavenProject)mavenProject.getProjectReferences().get(refId);
        if (project == null) {
            refId = artifact.getGroupId() + ":" + artifact.getArtifactId();
            project = (MavenProject)mavenProject.getProjectReferences().get(refId);
        }
        if (project != null) {
            File file = new File(project.getBuild().getOutputDirectory());
            this.log.debug((CharSequence)("Found directory: " + file.getAbsolutePath()));
            return file;
        }
        File file = artifact.getFile();
        this.log.debug((CharSequence)("Found file: " + file.getAbsolutePath()));
        if (file == null || !file.exists()) {
            throw new MojoExecutionException("Dependency Resolution Required " + artifact);
        }
        return file;
    }
}

