/*
 * Decompiled with CFR 0.152.
 */
package com.github.wnameless.json;

import com.eclipsesource.json.JsonObject;
import com.github.wnameless.json.JacksonJsonObject;
import com.github.wnameless.json.JsonObjectBase;
import com.github.wnameless.json.MinimalJsonValue;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public final class MinimalJsonObject
implements JsonObjectBase<MinimalJsonValue> {
    private final JsonObject jsonObject;

    public MinimalJsonObject(JsonObject jsonObject) {
        this.jsonObject = jsonObject;
    }

    @Override
    public MinimalJsonValue get(String name) {
        return new MinimalJsonValue(this.jsonObject.get(name));
    }

    public int hashCode() {
        return this.jsonObject.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JacksonJsonObject)) {
            return false;
        }
        return Objects.equals(this.jsonObject, ((MinimalJsonObject)o).jsonObject);
    }

    public String toString() {
        return this.jsonObject.toString();
    }

    @Override
    public Iterator<Map.Entry<String, MinimalJsonValue>> iterator() {
        return new MinimalJsonEntryIterator(this.jsonObject.iterator());
    }

    private final class MinimalJsonEntryIterator
    implements Iterator<Map.Entry<String, MinimalJsonValue>> {
        private final Iterator<JsonObject.Member> jsonMemberIterator;

        private MinimalJsonEntryIterator(Iterator<JsonObject.Member> jsonMemberIterator) {
            this.jsonMemberIterator = jsonMemberIterator;
        }

        @Override
        public boolean hasNext() {
            return this.jsonMemberIterator.hasNext();
        }

        @Override
        public Map.Entry<String, MinimalJsonValue> next() {
            JsonObject.Member member = this.jsonMemberIterator.next();
            return new AbstractMap.SimpleImmutableEntry<String, MinimalJsonValue>(member.getName(), new MinimalJsonValue(member.getValue()));
        }
    }
}

