/*
 * Decompiled with CFR 0.152.
 */
package com.github.wenhao.jpa.specification;

import com.github.wenhao.jpa.specification.AbstractSpecification;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;

public class EqualSpecification<T>
extends AbstractSpecification<T> {
    private final String property;
    private final Object[] values;

    public EqualSpecification(String property, Object ... values) {
        this.property = property;
        this.values = values;
    }

    public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
        From from = this.getRoot(this.property, (Root)root);
        String field = this.getProperty(this.property);
        if (this.values == null) {
            return cb.isNull((Expression)from.get(field));
        }
        if (this.values.length == 1) {
            return this.getPredicate(from, cb, this.values[0], field);
        }
        Predicate[] predicates = new Predicate[this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            predicates[i] = this.getPredicate((From)root, cb, this.values[i], field);
        }
        return cb.or(predicates);
    }

    private Predicate getPredicate(From root, CriteriaBuilder cb, Object value, String field) {
        return value == null ? cb.isNull((Expression)root.get(field)) : cb.equal((Expression)root.get(field), value);
    }
}

