/*
 * Decompiled with CFR 0.152.
 */
package com.github.vertical_blank.sqlformatter.languages;

import com.github.vertical_blank.sqlformatter.core.DialectConfig;
import com.github.vertical_blank.sqlformatter.core.FormatConfig;
import com.github.vertical_blank.sqlformatter.core.Formatter;
import com.github.vertical_blank.sqlformatter.core.Params;
import com.github.vertical_blank.sqlformatter.core.Tokenizer;
import java.util.List;
import java.util.Map;

public abstract class AbstractFormatter {
    abstract DialectConfig dialectConfig();

    public String format(String query, FormatConfig cfg) {
        Tokenizer tokenizer = new Tokenizer(this.dialectConfig());
        return new Formatter(cfg, tokenizer).format(query);
    }

    public String format(String query, String indent, List<?> params) {
        return this.format(query, FormatConfig.builder().indent(indent).params(Params.Holder.of(params)).build());
    }

    public String format(String query, List<?> params) {
        return this.format(query, "  ", params);
    }

    public String format(String query, String indent, Map<String, ?> params) {
        return this.format(query, FormatConfig.builder().indent(indent).params(Params.Holder.of(params)).build());
    }

    public String format(String query, Map<String, ?> params) {
        return this.format(query, "  ", params);
    }

    public String format(String query, String indent) {
        return this.format(query, FormatConfig.builder().indent(indent).build());
    }

    public String format(String query) {
        return this.format(query, "  ");
    }
}

