/*
 * Decompiled with CFR 0.152.
 */
package uk.org.lidalia.lang;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public class ThreadLocal<T> {
    private final Map<Thread, T> contents = new ConcurrentHashMap<Thread, T>();
    private final Supplier<T> initialValueCreator;
    private final Supplier<T> threadValueInitialiser = new Supplier<T>(){

        @Override
        public T get() {
            Object initialValue = ThreadLocal.this.initialValueCreator.get();
            ThreadLocal.this.set(initialValue);
            return initialValue;
        }
    };

    public ThreadLocal(T initialValue) {
        this(() -> Objects.requireNonNull(initialValue));
    }

    public ThreadLocal(Supplier<T> initialValueCreator) {
        this.initialValueCreator = Objects.requireNonNull(initialValueCreator);
    }

    public void set(T value) {
        this.contents.put(Thread.currentThread(), Objects.requireNonNull(value));
    }

    public T get() {
        return Optional.ofNullable(this.contents.get(Thread.currentThread())).orElseGet(this.threadValueInitialiser);
    }

    public void remove() {
        this.contents.remove(Thread.currentThread());
    }

    public void reset() {
        this.contents.clear();
    }

    public Collection<T> allValues() {
        return this.contents.values();
    }
}

