/*
 * Decompiled with CFR 0.152.
 */
package com.github.valfirst.slf4jtest;

import com.github.valfirst.slf4jtest.CleanupStage;
import com.github.valfirst.slf4jtest.TestLoggerFactory;
import com.github.valfirst.slf4jtest.TestLoggerFactorySettings;
import java.util.Optional;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;

public class TestLoggerFactoryExtension
implements BeforeEachCallback,
BeforeTestExecutionCallback {
    private final CleanupStage cleanupStage;

    public TestLoggerFactoryExtension() {
        this(CleanupStage.BEFORE_TEST_EXECUTION);
    }

    public TestLoggerFactoryExtension(CleanupStage cleanupStage) {
        this.cleanupStage = cleanupStage;
    }

    public void beforeEach(ExtensionContext context) {
        if (this.calculateCleanupStage(context) == CleanupStage.BEFORE_EACH) {
            TestLoggerFactory.clear();
        }
    }

    public void beforeTestExecution(ExtensionContext context) {
        if (this.calculateCleanupStage(context) == CleanupStage.BEFORE_TEST_EXECUTION) {
            TestLoggerFactory.clear();
        }
    }

    private CleanupStage calculateCleanupStage(ExtensionContext context) {
        return this.retrieveAnnotationFromTestClasses(context).map(TestLoggerFactorySettings::cleanupStage).orElse(this.cleanupStage);
    }

    private Optional<TestLoggerFactorySettings> retrieveAnnotationFromTestClasses(ExtensionContext context) {
        Optional annotation;
        ExtensionContext currentContext = context;
        do {
            annotation = AnnotationSupport.findAnnotation((Optional)currentContext.getElement(), TestLoggerFactorySettings.class);
            if (!currentContext.getParent().isPresent()) break;
            currentContext = (ExtensionContext)currentContext.getParent().get();
        } while (!annotation.isPresent() && currentContext != context.getRoot());
        return annotation;
    }
}

