/*
 * Decompiled with CFR 0.152.
 */
package com.github.tsc4j.credstash;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.regions.AwsRegionProvider;
import com.amazonaws.services.dynamodbv2.model.ResourceNotFoundException;
import com.github.tsc4j.aws.common.AwsConfig;
import com.github.tsc4j.aws.common.WithAwsConfig;
import com.github.tsc4j.aws.sdk1.AwsSdk1Utils;
import com.github.tsc4j.core.AbstractConfigValueProvider;
import com.github.tsc4j.core.Tsc4jCache;
import com.github.tsc4j.core.Tsc4jException;
import com.github.tsc4j.core.Tsc4jImplUtils;
import com.github.tsc4j.core.ValueProviderBuilder;
import com.github.tsc4j.core.WithCache;
import com.jessecoyle.CredStashBouncyCastleCrypto;
import com.jessecoyle.CredStashCrypto;
import com.jessecoyle.JCredStash;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueFactory;
import java.time.Clock;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;

public final class CredstashConfigValueProvider
extends AbstractConfigValueProvider
implements WithCache<String, ConfigValue> {
    static final String TYPE = "credstash";
    static final String DEFAULT_TABLE_NAME = "credential-store";
    private final JCredStash credstash;
    private final String tableName;
    private final Map<String, String> encryptionContext;
    private final Tsc4jCache<String, ConfigValue> cache;

    protected CredstashConfigValueProvider(@NonNull Builder builder) {
        this(builder, CredstashConfigValueProvider.createCredstash(builder));
        Objects.requireNonNull(builder, "builder is marked non-null but is null");
    }

    public String toString() {
        return super.toString();
    }

    protected CredstashConfigValueProvider(@NonNull Builder builder, @NonNull JCredStash credstash) {
        super(builder.getName(), TYPE, Collections.emptySet(), builder.isAllowMissing(), builder.isParallel());
        Objects.requireNonNull(builder, "builder is marked non-null but is null");
        Objects.requireNonNull(credstash, "credstash is marked non-null but is null");
        this.credstash = credstash;
        this.tableName = builder.getTableName();
        this.encryptionContext = Collections.unmodifiableMap(new LinkedHashMap<String, String>(builder.getEncryptionContext()));
        this.cache = Tsc4jImplUtils.newCache((String)this.toString(), (Duration)builder.getCacheTtl(), (Clock)builder.getClock());
    }

    private static JCredStash createCredstash(@NonNull Builder b) {
        Objects.requireNonNull(b, "b is marked non-null but is null");
        return CredstashConfigValueProvider.createCredstash(b.getTableName(), b.getAwsConfig());
    }

    static JCredStash createCredstash(@NonNull String tableName, @NonNull AwsConfig config) {
        Objects.requireNonNull(tableName, "tableName is marked non-null but is null");
        Objects.requireNonNull(config, "config is marked non-null but is null");
        AWSCredentialsProvider credentialProvider = AwsSdk1Utils.getCredentialsProvider((AwsConfig)config);
        AwsRegionProvider regionProvider = AwsSdk1Utils.getRegionProvider((AwsConfig)config);
        return new JCredStash(tableName.trim(), credentialProvider, regionProvider, (CredStashCrypto)new CredStashBouncyCastleCrypto());
    }

    static Supplier<JCredStash> createCredstashSupplier(@NonNull String tableName, @NonNull AwsConfig config) {
        Objects.requireNonNull(tableName, "tableName is marked non-null but is null");
        Objects.requireNonNull(config, "config is marked non-null but is null");
        return () -> CredstashConfigValueProvider.createCredstash(tableName, config);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getType() {
        return TYPE;
    }

    protected Map<String, ConfigValue> doGet(List<String> names) {
        LinkedHashMap<String, ConfigValue> res = new LinkedHashMap<String, ConfigValue>();
        this.runTasks(this.createFetchTasks(names), this.isParallel()).stream().forEach(e -> res.putAll((Map<String, ConfigValue>)e));
        return res;
    }

    protected void doClose() {
        Tsc4jImplUtils.close((AutoCloseable)this.credstash, (Logger)this.log);
        super.doClose();
    }

    private List<Callable<Map<String, ConfigValue>>> createFetchTasks(@NonNull Collection<String> credentialNames) {
        Objects.requireNonNull(credentialNames, "credentialNames is marked non-null but is null");
        return credentialNames.stream().map(name -> () -> this.getCredential((String)name)).collect(Collectors.toList());
    }

    protected Map<String, ConfigValue> getCredential(@NonNull String credentialName) {
        Objects.requireNonNull(credentialName, "credentialName is marked non-null but is null");
        return this.doGetCredential(credentialName).map(it -> Collections.singletonMap(credentialName, it)).orElse(Collections.emptyMap());
    }

    private Optional<ConfigValue> doGetCredential(@NonNull String credentialName) {
        Objects.requireNonNull(credentialName, "credentialName is marked non-null but is null");
        try {
            return this.getFromCache(credentialName).map(Optional::of).orElseGet(() -> this.getCredentialFromCredstash(credentialName));
        }
        catch (Tsc4jException e) {
            throw e;
        }
        catch (Exception e) {
            throw Tsc4jException.of((String)"Error fetching credstash credential '%s': %%s", (Throwable)e, (Object[])new Object[]{credentialName});
        }
    }

    private Optional<ConfigValue> getCredentialFromCredstash(@NonNull String credentialName) {
        Objects.requireNonNull(credentialName, "credentialName is marked non-null but is null");
        String name = this.fixCredentialName(credentialName);
        if (name.isEmpty()) {
            return Optional.empty();
        }
        return this.doGetCredentialFromCredstash(name);
    }

    private Optional<ConfigValue> doGetCredentialFromCredstash(String credentialName) {
        this.log.debug("{} fetching credential from credstash: '{}'", (Object)this, (Object)credentialName);
        try {
            String secret = this.credstash.getSecret(credentialName, this.encryptionContext);
            return Optional.ofNullable(secret).map(it -> this.toConfigValue(credentialName, (String)it)).map(it -> (ConfigValue)this.putToCache(credentialName, it));
        }
        catch (ResourceNotFoundException e) {
            throw Tsc4jException.of((String)"Cannot read credstash table '%s': %%s", (Throwable)e, (Object[])new Object[]{this.tableName});
        }
        catch (RuntimeException e) {
            if (this.isNotFoundException(e)) {
                if (this.allowMissing()) {
                    this.log.warn("{} credstash doesn't contain credential: '{}'", (Object)this, (Object)credentialName);
                    return Optional.empty();
                }
                throw Tsc4jException.of((String)"Credstash credential doesn't exist: %s", (Throwable)e, (Object[])new Object[]{credentialName});
            }
            throw e;
        }
    }

    private ConfigValue toConfigValue(@NonNull String credentialName, @NonNull String value) {
        Objects.requireNonNull(credentialName, "credentialName is marked non-null but is null");
        Objects.requireNonNull(value, "value is marked non-null but is null");
        String originDescription = String.format("%s:/%s", TYPE, credentialName);
        return ConfigValueFactory.fromAnyRef((Object)value, (String)originDescription);
    }

    private String fixCredentialName(String credentialName) {
        return credentialName.trim().replaceFirst("^credential=", "").trim();
    }

    private boolean isNotFoundException(@NonNull RuntimeException e) {
        Objects.requireNonNull(e, "e is marked non-null but is null");
        String msg = e.getMessage();
        return msg.startsWith("Secret ") && msg.endsWith(" could not be found");
    }

    @Generated
    public Tsc4jCache<String, ConfigValue> getCache() {
        return this.cache;
    }

    public static class Builder
    extends ValueProviderBuilder<Builder>
    implements WithAwsConfig<Builder> {
        private AwsConfig awsConfig = new AwsConfig();
        private String tableName = "credential-store";
        private Map<String, String> encryptionContext = Collections.emptyMap();

        public Builder withEncryptionContext(@NonNull Config cfg) {
            Objects.requireNonNull(cfg, "cfg is marked non-null but is null");
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            cfg.root().forEach((key, value1) -> {
                Object value = value1.unwrapped();
                if (value != null) {
                    map.put((String)key, value.toString());
                }
            });
            return this.setEncryptionContext(map);
        }

        protected Duration defaultCacheTtl() {
            return Duration.ofMinutes(15L);
        }

        protected Builder checkState() {
            String tn = this.getTableName().trim();
            if (tn.isEmpty()) {
                throw new IllegalStateException("dynamoDb table name cannot be empty.");
            }
            return (Builder)super.checkState();
        }

        public void withConfig(@NonNull Config cfg) {
            Objects.requireNonNull(cfg, "cfg is marked non-null but is null");
            super.withConfig(cfg);
            this.getAwsConfig().withConfig(cfg);
            this.cfgString(cfg, "table-name", this::setTableName);
            this.cfgConfig(cfg, "encryption-context", this::withEncryptionContext);
        }

        public CredstashConfigValueProvider build() {
            return new CredstashConfigValueProvider(this);
        }

        @Generated
        public Builder() {
        }

        @Generated
        public String getTableName() {
            return this.tableName;
        }

        @Generated
        public Map<String, String> getEncryptionContext() {
            return this.encryptionContext;
        }

        @Generated
        public Builder setAwsConfig(AwsConfig awsConfig) {
            this.awsConfig = awsConfig;
            return this;
        }

        @Generated
        public Builder setTableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        @Generated
        public Builder setEncryptionContext(Map<String, String> encryptionContext) {
            this.encryptionContext = encryptionContext;
            return this;
        }

        @Generated
        public String toString() {
            return "CredstashConfigValueProvider.Builder(awsConfig=" + this.getAwsConfig() + ", tableName=" + this.getTableName() + ", encryptionContext=" + this.getEncryptionContext() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Builder)) {
                return false;
            }
            Builder other = (Builder)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            return super.equals(o);
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Builder;
        }

        @Generated
        public int hashCode() {
            int result = super.hashCode();
            return result;
        }

        @Generated
        public AwsConfig getAwsConfig() {
            return this.awsConfig;
        }
    }
}

