/*
 * Decompiled with CFR 0.152.
 */
package com.github.tsc4j.credstash;

import com.github.tsc4j.aws.common.AwsCliCommand;
import com.github.tsc4j.core.Tsc4jImplUtils;
import com.github.tsc4j.credstash.CredstashConfigValueProvider;
import com.jessecoyle.CredentialVersion;
import com.jessecoyle.JCredStash;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(description={"Credstash test command."}, sortOptions=false)
public final class CredstashCommand
extends AwsCliCommand {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CredstashCommand.class);
    private static final String KEY_FMT = "%-50.50s";
    private static final String VERSION_FMT = "%-9.9s";
    private static final String LIST_FMT = "%-50.50s %-9.9s\n";
    private static final String DISPLAY_FMT = "%-50.50s %s\n";
    @CommandLine.Option(names={"-t", "--table"}, description={"credstash dynamodb table name (default: ${DEFAULT-VALUE})"})
    private String tableName = "credential-store";
    @CommandLine.Option(names={"-L", "--list"}, description={"Lists credstash credentials"})
    private boolean listCredentials = false;
    @CommandLine.Option(names={"-A", "--all"}, description={"Fetch all credstash secrets"})
    private boolean fetchAll = false;
    @CommandLine.Parameters(description={"fetch specified credentials"})
    private List<String> credentials = new ArrayList<String>();

    protected int doCall() {
        Supplier<JCredStash> credstashSupplier = CredstashConfigValueProvider.createCredstashSupplier(this.tableName, this.getAwsConfig());
        if (this.listCredentials) {
            return this.listSecrets(credstashSupplier.get());
        }
        if (!this.fetchAll && this.credentials.isEmpty()) {
            throw new CommandLine.PicocliException("No credential names to fetch were specified. Run with --help for instructions.");
        }
        return this.fetchSecrets(credstashSupplier.get(), this.credentials);
    }

    public String getName() {
        return "credstash";
    }

    private int fetchSecrets(@NonNull JCredStash credstash, @NonNull Collection<String> credentials) {
        Objects.requireNonNull(credstash, "credstash is marked non-null but is null");
        Objects.requireNonNull(credentials, "credentials is marked non-null but is null");
        Collection names = this.fetchAll ? (Collection)this.getSecrets(credstash, true).stream().map(e -> e.getName()).collect(Collectors.toList()) : credentials;
        log.debug("fetching {} credstash credentials: {}", (Object)names.size(), names);
        Map kmsCtx = Collections.emptyMap();
        TreeMap<String, String> credentialMap = new TreeMap<String, String>();
        List callables = Tsc4jImplUtils.toUniqueList((Collection)names).stream().map(name -> this.createFetchCredentialCallable(credstash, (String)name, kmsCtx, (Map<String, String>)credentialMap)).collect(Collectors.toList());
        List results = this.runTasks(callables, true);
        log.debug("parallelCall() returned {} results.", (Object)results.size());
        if (!credentialMap.isEmpty()) {
            this.getStderr().printf(DISPLAY_FMT, "credential", "secret");
            credentialMap.forEach((name, secret) -> this.getStdout().printf(DISPLAY_FMT, name, secret));
        }
        return 0;
    }

    private Callable<String> createFetchCredentialCallable(@NonNull JCredStash credstash, @NonNull String credentialName, @NonNull Map<String, String> kmsCtx, @NonNull Map<String, String> credentialMap) {
        Objects.requireNonNull(credstash, "credstash is marked non-null but is null");
        Objects.requireNonNull(credentialName, "credentialName is marked non-null but is null");
        Objects.requireNonNull(kmsCtx, "kmsCtx is marked non-null but is null");
        Objects.requireNonNull(credentialMap, "credentialMap is marked non-null but is null");
        return () -> {
            String secret = this.fetchCredential(credstash, credentialName, kmsCtx);
            credentialMap.put(credentialName, secret);
            return secret;
        };
    }

    private String fetchCredential(@NonNull JCredStash credstash, @NonNull String credentialName, @NonNull Map<String, String> kmsCtx) {
        Objects.requireNonNull(credstash, "credstash is marked non-null but is null");
        Objects.requireNonNull(credentialName, "credentialName is marked non-null but is null");
        Objects.requireNonNull(kmsCtx, "kmsCtx is marked non-null but is null");
        long ts = System.currentTimeMillis();
        String secret = credstash.getSecret(credentialName, kmsCtx);
        long duration = System.currentTimeMillis() - ts;
        log.debug("fetched credstash secret {} in {} msec.", (Object)credentialName, (Object)duration);
        return secret.trim();
    }

    private int listSecrets(@NonNull JCredStash credstash) {
        Objects.requireNonNull(credstash, "credstash is marked non-null but is null");
        log.debug("listing credstash credentials.");
        long ts = System.currentTimeMillis();
        List<CredentialVersion> secrets = this.getSecrets(credstash, true);
        long duration = System.currentTimeMillis() - ts;
        log.debug("retrieved {} credstash credentials in {} msec.", (Object)secrets.size(), (Object)duration);
        this.getStderr().printf(LIST_FMT, "credential", "version");
        secrets.forEach(e -> this.getStdout().printf(LIST_FMT, e.getName(), CredstashCommand.cleanupVersion(e.getVersion())));
        return 0;
    }

    private static String cleanupVersion(@NonNull String version) {
        Objects.requireNonNull(version, "version is marked non-null but is null");
        return version.replaceAll("^0*", "");
    }

    private List<CredentialVersion> getSecrets(@NonNull JCredStash credstash, boolean onlyLastVersion) {
        Objects.requireNonNull(credstash, "credstash is marked non-null but is null");
        List<CredentialVersion> secrets = credstash.listSecrets();
        return onlyLastVersion ? this.latestSecretVersions((Collection<CredentialVersion>)secrets) : secrets;
    }

    private List<CredentialVersion> latestSecretVersions(@NonNull Collection<CredentialVersion> creds) {
        Objects.requireNonNull(creds, "creds is marked non-null but is null");
        HashMap map = new HashMap();
        creds.forEach(e -> {
            String name = e.getName();
            CredentialVersion value = (CredentialVersion)map.get(name);
            if (value == null) {
                map.put(name, e);
            } else {
                long prevVersion;
                long curVersion = Long.parseLong(CredstashCommand.cleanupVersion(e.getVersion()));
                if (curVersion > (prevVersion = Long.parseLong(CredstashCommand.cleanupVersion(value.getVersion())))) {
                    map.put(name, e);
                }
            }
        });
        return map.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    public String getGroup() {
        return "misc";
    }

    @Generated
    public String toString() {
        return "CredstashCommand(tableName=" + this.tableName + ", listCredentials=" + this.listCredentials + ", fetchAll=" + this.fetchAll + ", credentials=" + this.credentials + ")";
    }
}

