/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.mortbay.jetty;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.servlet.ServletException;
import wiremock.org.mortbay.component.Container;
import wiremock.org.mortbay.component.LifeCycle;
import wiremock.org.mortbay.jetty.Connector;
import wiremock.org.mortbay.jetty.Handler;
import wiremock.org.mortbay.jetty.HttpConnection;
import wiremock.org.mortbay.jetty.HttpGenerator;
import wiremock.org.mortbay.jetty.SessionIdManager;
import wiremock.org.mortbay.jetty.bio.SocketConnector;
import wiremock.org.mortbay.jetty.handler.HandlerCollection;
import wiremock.org.mortbay.jetty.handler.HandlerWrapper;
import wiremock.org.mortbay.jetty.security.UserRealm;
import wiremock.org.mortbay.log.Log;
import wiremock.org.mortbay.thread.QueuedThreadPool;
import wiremock.org.mortbay.thread.ThreadPool;
import wiremock.org.mortbay.util.Attributes;
import wiremock.org.mortbay.util.AttributesMap;
import wiremock.org.mortbay.util.LazyList;
import wiremock.org.mortbay.util.MultiException;

public class Server
extends HandlerWrapper
implements Attributes {
    public static final String UNKNOWN_VERSION = "6.1.x";
    public static final String SNAPSHOT_VERSION = "6.1-SNAPSHOT";
    private static ShutdownHookThread hookThread = new ShutdownHookThread();
    private static String _version = Server.class.getPackage() != null && Server.class.getPackage().getImplementationVersion() != null ? Server.class.getPackage().getImplementationVersion() : "6.1.x";
    private ThreadPool _threadPool;
    private Connector[] _connectors;
    private UserRealm[] _realms;
    private Container _container = new Container();
    private SessionIdManager _sessionIdManager;
    private boolean _sendServerVersion = true;
    private boolean _sendDateHeader = false;
    private AttributesMap _attributes = new AttributesMap();
    private List _dependentLifeCycles = new ArrayList();
    private int _graceful = 0;
    static /* synthetic */ Class class$java$lang$Thread;
    static /* synthetic */ Class class$java$lang$Runtime;

    public Server() {
        this.setServer(this);
    }

    public Server(int port) {
        this.setServer(this);
        SocketConnector connector = new SocketConnector();
        connector.setPort(port);
        this.setConnectors(new Connector[]{connector});
    }

    public static String getVersion() {
        return _version;
    }

    public Container getContainer() {
        return this._container;
    }

    public boolean getStopAtShutdown() {
        return hookThread.contains(this);
    }

    public void setStopAtShutdown(boolean stop) {
        if (stop) {
            hookThread.add(this);
        } else {
            hookThread.remove(this);
        }
    }

    public Connector[] getConnectors() {
        return this._connectors;
    }

    public void addConnector(Connector connector) {
        this.setConnectors((Connector[])LazyList.addToArray(this.getConnectors(), connector, Connector.class));
    }

    public void removeConnector(Connector connector) {
        this.setConnectors((Connector[])LazyList.removeFromArray(this.getConnectors(), connector));
    }

    public void setConnectors(Connector[] connectors) {
        if (connectors != null) {
            for (int i = 0; i < connectors.length; ++i) {
                connectors[i].setServer(this);
            }
        }
        this._container.update((Object)this, this._connectors, connectors, "connector");
        this._connectors = connectors;
    }

    public ThreadPool getThreadPool() {
        return this._threadPool;
    }

    public void setThreadPool(ThreadPool threadPool) {
        this._container.update((Object)this, this._threadPool, threadPool, "threadpool", true);
        this._threadPool = threadPool;
    }

    protected void doStart() throws Exception {
        Log.info("jetty-" + _version);
        HttpGenerator.setServerVersion(_version);
        MultiException mex = new MultiException();
        for (int i = 0; this._realms != null && i < this._realms.length; ++i) {
            if (!(this._realms[i] instanceof LifeCycle)) continue;
            ((LifeCycle)((Object)this._realms[i])).start();
        }
        Iterator itor = this._dependentLifeCycles.iterator();
        while (itor.hasNext()) {
            try {
                ((LifeCycle)itor.next()).start();
            }
            catch (Throwable e) {
                mex.add(e);
            }
        }
        if (this._threadPool == null) {
            QueuedThreadPool tp = new QueuedThreadPool();
            this.setThreadPool(tp);
        }
        if (this._sessionIdManager != null) {
            this._sessionIdManager.start();
        }
        try {
            if (this._threadPool instanceof LifeCycle) {
                ((LifeCycle)((Object)this._threadPool)).start();
            }
        }
        catch (Throwable e) {
            mex.add(e);
        }
        try {
            super.doStart();
        }
        catch (Throwable e) {
            Log.warn("Error starting handlers", e);
        }
        if (this._connectors != null) {
            for (int i = 0; i < this._connectors.length; ++i) {
                try {
                    this._connectors[i].start();
                    continue;
                }
                catch (Throwable e) {
                    mex.add(e);
                }
            }
        }
        mex.ifExceptionThrow();
    }

    protected void doStop() throws Exception {
        int i;
        MultiException mex = new MultiException();
        for (i = 0; this._realms != null && i < this._realms.length; ++i) {
            if (!(this._realms[i] instanceof LifeCycle)) continue;
            ((LifeCycle)((Object)this._realms[i])).stop();
        }
        if (this._graceful > 0) {
            if (this._connectors != null) {
                i = this._connectors.length;
                while (i-- > 0) {
                    Log.info("Graceful shutdown {}", this._connectors[i]);
                    try {
                        this._connectors[i].close();
                    }
                    catch (Throwable e) {
                        mex.add(e);
                    }
                }
            }
            Handler[] contexts = this.getChildHandlersByClass(Graceful.class);
            for (int c = 0; c < contexts.length; ++c) {
                Graceful context = (Graceful)((Object)contexts[c]);
                Log.info("Graceful shutdown {}", context);
                context.setShutdown(true);
            }
            Thread.sleep(this._graceful);
        }
        if (this._connectors != null) {
            i = this._connectors.length;
            while (i-- > 0) {
                try {
                    this._connectors[i].stop();
                }
                catch (Throwable e) {
                    mex.add(e);
                }
            }
        }
        try {
            super.doStop();
        }
        catch (Throwable e) {
            mex.add(e);
        }
        if (this._sessionIdManager != null) {
            this._sessionIdManager.stop();
        }
        try {
            if (this._threadPool instanceof LifeCycle) {
                ((LifeCycle)((Object)this._threadPool)).stop();
            }
        }
        catch (Throwable e) {
            mex.add(e);
        }
        if (!this._dependentLifeCycles.isEmpty()) {
            ListIterator itor = this._dependentLifeCycles.listIterator(this._dependentLifeCycles.size());
            while (itor.hasPrevious()) {
                try {
                    ((LifeCycle)itor.previous()).stop();
                }
                catch (Throwable e) {
                    mex.add(e);
                }
            }
        }
        mex.ifExceptionThrow();
    }

    public void handle(HttpConnection connection) throws IOException, ServletException {
        String target = connection.getRequest().getPathInfo();
        if (Log.isDebugEnabled()) {
            Log.debug("REQUEST " + target + " on " + connection);
            this.handle(target, connection.getRequest(), connection.getResponse(), 1);
            Log.debug("RESPONSE " + target + "  " + connection.getResponse().getStatus());
        } else {
            this.handle(target, connection.getRequest(), connection.getResponse(), 1);
        }
    }

    public void join() throws InterruptedException {
        this.getThreadPool().join();
    }

    public UserRealm[] getUserRealms() {
        return this._realms;
    }

    public void setUserRealms(UserRealm[] realms) {
        this._container.update((Object)this, this._realms, realms, "realm", true);
        this._realms = realms;
    }

    public void addUserRealm(UserRealm realm) {
        this.setUserRealms((UserRealm[])LazyList.addToArray(this.getUserRealms(), realm, UserRealm.class));
    }

    public void removeUserRealm(UserRealm realm) {
        this.setUserRealms((UserRealm[])LazyList.removeFromArray(this.getUserRealms(), realm));
    }

    public SessionIdManager getSessionIdManager() {
        return this._sessionIdManager;
    }

    public void setSessionIdManager(SessionIdManager sessionIdManager) {
        this._container.update((Object)this, this._sessionIdManager, sessionIdManager, "sessionIdManager", true);
        this._sessionIdManager = sessionIdManager;
    }

    public void setSendServerVersion(boolean sendServerVersion) {
        this._sendServerVersion = sendServerVersion;
    }

    public boolean getSendServerVersion() {
        return this._sendServerVersion;
    }

    public void setSendDateHeader(boolean sendDateHeader) {
        this._sendDateHeader = sendDateHeader;
    }

    public boolean getSendDateHeader() {
        return this._sendDateHeader;
    }

    public void addLifeCycle(LifeCycle c) {
        if (c == null) {
            return;
        }
        if (!this._dependentLifeCycles.contains(c)) {
            this._dependentLifeCycles.add(c);
            this._container.addBean(c);
        }
        try {
            if (this.isStarted()) {
                c.start();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void removeLifeCycle(LifeCycle c) {
        if (c == null) {
            return;
        }
        this._dependentLifeCycles.remove(c);
        this._container.removeBean(c);
    }

    public void addHandler(Handler handler) {
        if (this.getHandler() == null) {
            this.setHandler(handler);
        } else if (this.getHandler() instanceof HandlerCollection) {
            ((HandlerCollection)this.getHandler()).addHandler(handler);
        } else {
            HandlerCollection collection = new HandlerCollection();
            collection.setHandlers(new Handler[]{this.getHandler(), handler});
            this.setHandler(collection);
        }
    }

    public void removeHandler(Handler handler) {
        if (this.getHandler() instanceof HandlerCollection) {
            ((HandlerCollection)this.getHandler()).removeHandler(handler);
        }
    }

    public Handler[] getHandlers() {
        if (this.getHandler() instanceof HandlerCollection) {
            return ((HandlerCollection)this.getHandler()).getHandlers();
        }
        return null;
    }

    public void setHandlers(Handler[] handlers) {
        HandlerCollection collection;
        if (this.getHandler() instanceof HandlerCollection) {
            collection = (HandlerCollection)this.getHandler();
        } else {
            collection = new HandlerCollection();
            this.setHandler(collection);
        }
        collection.setHandlers(handlers);
    }

    public void clearAttributes() {
        this._attributes.clearAttributes();
    }

    public Object getAttribute(String name) {
        return this._attributes.getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        return AttributesMap.getAttributeNamesCopy(this._attributes);
    }

    public void removeAttribute(String name) {
        this._attributes.removeAttribute(name);
    }

    public void setAttribute(String name, Object attribute) {
        this._attributes.setAttribute(name, attribute);
    }

    public int getGracefulShutdown() {
        return this._graceful;
    }

    public void setGracefulShutdown(int timeoutMS) {
        this._graceful = timeoutMS;
    }

    public static interface Graceful {
        public void setShutdown(boolean var1);
    }

    private static class ShutdownHookThread
    extends Thread {
        private boolean hooked = false;
        private ArrayList servers = new ArrayList();

        private ShutdownHookThread() {
        }

        private void createShutdownHook() {
            block3: {
                if (!Boolean.getBoolean("JETTY_NO_SHUTDOWN_HOOK") && !this.hooked) {
                    try {
                        Method shutdownHook = (class$java$lang$Runtime == null ? (class$java$lang$Runtime = Server.class$("java.lang.Runtime")) : class$java$lang$Runtime).getMethod("addShutdownHook", class$java$lang$Thread == null ? (class$java$lang$Thread = Server.class$("java.lang.Thread")) : class$java$lang$Thread);
                        shutdownHook.invoke((Object)Runtime.getRuntime(), this);
                        this.hooked = true;
                    }
                    catch (Exception e) {
                        if (!Log.isDebugEnabled()) break block3;
                        Log.debug("No shutdown hook in JVM ", e);
                    }
                }
            }
        }

        public boolean add(Server server) {
            this.createShutdownHook();
            return this.servers.add(server);
        }

        public boolean contains(Server server) {
            return this.servers.contains(server);
        }

        public boolean addAll(Collection c) {
            this.createShutdownHook();
            return this.servers.addAll(c);
        }

        public void clear() {
            this.createShutdownHook();
            this.servers.clear();
        }

        public boolean remove(Server server) {
            this.createShutdownHook();
            return this.servers.remove(server);
        }

        public boolean removeAll(Collection c) {
            this.createShutdownHook();
            return this.servers.removeAll(c);
        }

        public void run() {
            this.setName("Shutdown");
            Log.info("Shutdown hook executing");
            Iterator it = this.servers.iterator();
            while (it.hasNext()) {
                Server svr = (Server)it.next();
                if (svr == null) continue;
                try {
                    svr.stop();
                }
                catch (Exception e) {
                    Log.warn(e);
                }
                Log.info("Shutdown hook complete");
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception e) {
                    Log.warn(e);
                }
            }
        }
    }
}

