/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.apache.http.protocol;

import java.io.IOException;
import wiremock.org.apache.http.HttpEntityEnclosingRequest;
import wiremock.org.apache.http.HttpException;
import wiremock.org.apache.http.HttpRequest;
import wiremock.org.apache.http.HttpRequestInterceptor;
import wiremock.org.apache.http.annotation.ThreadSafe;
import wiremock.org.apache.http.protocol.HttpContext;
import wiremock.org.apache.http.protocol.HttpDateGenerator;

@ThreadSafe
public class RequestDate
implements HttpRequestInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null.");
        }
        if (request instanceof HttpEntityEnclosingRequest && !request.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            request.setHeader("Date", httpdate);
        }
    }
}

