/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.google.common.collect;

import java.util.Comparator;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import wiremock.com.google.common.annotations.GwtCompatible;
import wiremock.com.google.common.base.Preconditions;
import wiremock.com.google.common.base.Supplier;
import wiremock.com.google.common.collect.RowSortedTable;
import wiremock.com.google.common.collect.StandardTable;

@GwtCompatible
class StandardRowSortedTable<R, C, V>
extends StandardTable<R, C, V>
implements RowSortedTable<R, C, V> {
    private transient SortedSet<R> rowKeySet;
    private transient RowSortedMap rowMap;
    private static final long serialVersionUID = 0L;

    StandardRowSortedTable(SortedMap<R, Map<C, V>> backingMap, Supplier<? extends Map<C, V>> factory) {
        super(backingMap, factory);
    }

    private SortedMap<R, Map<C, V>> sortedBackingMap() {
        return (SortedMap)this.backingMap;
    }

    @Override
    public SortedSet<R> rowKeySet() {
        RowKeySortedSet result = this.rowKeySet;
        return result == null ? (this.rowKeySet = new RowKeySortedSet()) : result;
    }

    @Override
    public SortedMap<R, Map<C, V>> rowMap() {
        RowSortedMap result = this.rowMap;
        return result == null ? (this.rowMap = new RowSortedMap()) : result;
    }

    private class RowSortedMap
    extends StandardTable.RowMap
    implements SortedMap<R, Map<C, V>> {
        private RowSortedMap() {
            super(StandardRowSortedTable.this);
        }

        @Override
        public Comparator<? super R> comparator() {
            return StandardRowSortedTable.this.sortedBackingMap().comparator();
        }

        @Override
        public R firstKey() {
            return StandardRowSortedTable.this.sortedBackingMap().firstKey();
        }

        @Override
        public R lastKey() {
            return StandardRowSortedTable.this.sortedBackingMap().lastKey();
        }

        @Override
        public SortedMap<R, Map<C, V>> headMap(R toKey) {
            Preconditions.checkNotNull(toKey);
            return new StandardRowSortedTable(StandardRowSortedTable.this.sortedBackingMap().headMap(toKey), StandardRowSortedTable.this.factory).rowMap();
        }

        @Override
        public SortedMap<R, Map<C, V>> subMap(R fromKey, R toKey) {
            Preconditions.checkNotNull(fromKey);
            Preconditions.checkNotNull(toKey);
            return new StandardRowSortedTable(StandardRowSortedTable.this.sortedBackingMap().subMap(fromKey, toKey), StandardRowSortedTable.this.factory).rowMap();
        }

        @Override
        public SortedMap<R, Map<C, V>> tailMap(R fromKey) {
            Preconditions.checkNotNull(fromKey);
            return new StandardRowSortedTable(StandardRowSortedTable.this.sortedBackingMap().tailMap(fromKey), StandardRowSortedTable.this.factory).rowMap();
        }
    }

    private class RowKeySortedSet
    extends StandardTable.RowKeySet
    implements SortedSet<R> {
        private RowKeySortedSet() {
            super(StandardRowSortedTable.this);
        }

        @Override
        public Comparator<? super R> comparator() {
            return StandardRowSortedTable.this.sortedBackingMap().comparator();
        }

        @Override
        public R first() {
            return StandardRowSortedTable.this.sortedBackingMap().firstKey();
        }

        @Override
        public R last() {
            return StandardRowSortedTable.this.sortedBackingMap().lastKey();
        }

        @Override
        public SortedSet<R> headSet(R toElement) {
            Preconditions.checkNotNull(toElement);
            return new StandardRowSortedTable(StandardRowSortedTable.this.sortedBackingMap().headMap(toElement), StandardRowSortedTable.this.factory).rowKeySet();
        }

        @Override
        public SortedSet<R> subSet(R fromElement, R toElement) {
            Preconditions.checkNotNull(fromElement);
            Preconditions.checkNotNull(toElement);
            return new StandardRowSortedTable(StandardRowSortedTable.this.sortedBackingMap().subMap(fromElement, toElement), StandardRowSortedTable.this.factory).rowKeySet();
        }

        @Override
        public SortedSet<R> tailSet(R fromElement) {
            Preconditions.checkNotNull(fromElement);
            return new StandardRowSortedTable(StandardRowSortedTable.this.sortedBackingMap().tailMap(fromElement), StandardRowSortedTable.this.factory).rowKeySet();
        }
    }
}

