/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.fasterxml.jackson.databind.ser.std;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.concurrent.atomic.AtomicReference;
import wiremock.com.fasterxml.jackson.core.JsonGenerationException;
import wiremock.com.fasterxml.jackson.core.JsonGenerator;
import wiremock.com.fasterxml.jackson.databind.JavaType;
import wiremock.com.fasterxml.jackson.databind.JsonMappingException;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.com.fasterxml.jackson.databind.JsonSerializable;
import wiremock.com.fasterxml.jackson.databind.ObjectMapper;
import wiremock.com.fasterxml.jackson.databind.SerializerProvider;
import wiremock.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import wiremock.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import wiremock.com.fasterxml.jackson.databind.jsonschema.JsonSerializableSchema;
import wiremock.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import wiremock.com.fasterxml.jackson.databind.node.ObjectNode;
import wiremock.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import wiremock.com.fasterxml.jackson.databind.type.TypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JacksonStdImpl
public class SerializableSerializer
extends StdSerializer<JsonSerializable> {
    public static final SerializableSerializer instance = new SerializableSerializer();
    private static final AtomicReference<ObjectMapper> _mapperReference = new AtomicReference();

    protected SerializableSerializer() {
        super(JsonSerializable.class);
    }

    @Override
    public void serialize(JsonSerializable value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        value.serialize(jgen, provider);
    }

    @Override
    public final void serializeWithType(JsonSerializable value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonGenerationException {
        value.serializeWithType(jgen, provider, typeSer);
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        Class<?> rawClass;
        ObjectNode objectNode = this.createObjectNode();
        String schemaType = "any";
        String objectProperties = null;
        String itemDefinition = null;
        if (typeHint != null && (rawClass = TypeFactory.rawClass(typeHint)).isAnnotationPresent(JsonSerializableSchema.class)) {
            JsonSerializableSchema schemaInfo = rawClass.getAnnotation(JsonSerializableSchema.class);
            schemaType = schemaInfo.schemaType();
            if (!"##irrelevant".equals(schemaInfo.schemaObjectPropertiesDefinition())) {
                objectProperties = schemaInfo.schemaObjectPropertiesDefinition();
            }
            if (!"##irrelevant".equals(schemaInfo.schemaItemDefinition())) {
                itemDefinition = schemaInfo.schemaItemDefinition();
            }
        }
        objectNode.put("type", schemaType);
        if (objectProperties != null) {
            try {
                objectNode.put("properties", SerializableSerializer._getObjectMapper().readTree(objectProperties));
            }
            catch (IOException e) {
                throw new JsonMappingException("Failed to parse @JsonSerializableSchema.schemaObjectPropertiesDefinition value");
            }
        }
        if (itemDefinition != null) {
            try {
                objectNode.put("items", SerializableSerializer._getObjectMapper().readTree(itemDefinition));
            }
            catch (IOException e) {
                throw new JsonMappingException("Failed to parse @JsonSerializableSchema.schemaItemDefinition value");
            }
        }
        return objectNode;
    }

    private static final synchronized ObjectMapper _getObjectMapper() {
        ObjectMapper mapper = _mapperReference.get();
        if (mapper == null) {
            mapper = new ObjectMapper();
            _mapperReference.set(mapper);
        }
        return mapper;
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) {
        visitor.expectAnyFormat(typeHint);
    }
}

