/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.core;

import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.HttpsSettings;
import com.github.tomakehurst.wiremock.common.Log4jNotifier;
import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.common.ProxySettings;
import com.github.tomakehurst.wiremock.common.SingleRootFileSource;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.http.CaseInsensitiveKey;
import java.util.List;
import wiremock.com.google.common.collect.Lists;

public class WireMockConfiguration
implements Options {
    private int portNumber = 8080;
    private String bindAddress = "0.0.0.0";
    private Integer httpsPort = null;
    private String keyStorePath = null;
    private boolean browserProxyingEnabled = false;
    private ProxySettings proxySettings;
    private FileSource filesRoot = new SingleRootFileSource("src/test/resources");
    private Notifier notifier = new Log4jNotifier();
    private boolean requestJournalDisabled = false;
    private List<CaseInsensitiveKey> matchingHeaders;
    private String proxyUrl;
    private boolean preserveHostHeader;
    private String proxyHostHeader;

    public static WireMockConfiguration wireMockConfig() {
        return new WireMockConfiguration();
    }

    public WireMockConfiguration port(int portNumber) {
        this.portNumber = portNumber;
        return this;
    }

    public WireMockConfiguration httpsPort(Integer httpsPort) {
        this.httpsPort = httpsPort;
        return this;
    }

    public WireMockConfiguration keystorePath(String path) {
        this.keyStorePath = path;
        return this;
    }

    public WireMockConfiguration enableBrowserProxying(boolean enabled) {
        this.browserProxyingEnabled = enabled;
        return this;
    }

    public WireMockConfiguration proxyVia(String host, int port) {
        this.proxySettings = new ProxySettings(host, port);
        return this;
    }

    public WireMockConfiguration proxyVia(ProxySettings proxySettings) {
        this.proxySettings = proxySettings;
        return this;
    }

    public WireMockConfiguration withRootDirectory(String path) {
        this.filesRoot = new SingleRootFileSource(path);
        return this;
    }

    public WireMockConfiguration fileSource(FileSource fileSource) {
        this.filesRoot = fileSource;
        return this;
    }

    public WireMockConfiguration notifier(Notifier notifier) {
        this.notifier = notifier;
        return this;
    }

    public WireMockConfiguration bindAddress(String bindAddress) {
        this.bindAddress = bindAddress;
        return this;
    }

    public WireMockConfiguration disableRequestJournal() {
        this.requestJournalDisabled = true;
        return this;
    }

    public WireMockConfiguration recordRequestHeadersForMatching(List<String> headers) {
        this.matchingHeaders = Lists.transform(headers, CaseInsensitiveKey.TO_CASE_INSENSITIVE_KEYS);
        return this;
    }

    public WireMockConfiguration withProxyUrl(String proxyUrl) {
        this.proxyUrl = proxyUrl;
        return this;
    }

    public WireMockConfiguration preserveHostHeader(boolean preserveHostHeader) {
        this.preserveHostHeader = preserveHostHeader;
        return this;
    }

    public WireMockConfiguration proxyHostHeader(String hostHeaderValue) {
        this.proxyHostHeader = hostHeaderValue;
        return this;
    }

    @Override
    public int portNumber() {
        return this.portNumber;
    }

    @Override
    public HttpsSettings httpsSettings() {
        if (this.httpsPort == null) {
            return HttpsSettings.NO_HTTPS;
        }
        if (this.keyStorePath == null) {
            return new HttpsSettings(this.httpsPort);
        }
        return new HttpsSettings(this.httpsPort, this.keyStorePath);
    }

    @Override
    public boolean browserProxyingEnabled() {
        return this.browserProxyingEnabled;
    }

    @Override
    public ProxySettings proxyVia() {
        return this.proxySettings;
    }

    @Override
    public FileSource filesRoot() {
        return this.filesRoot;
    }

    @Override
    public Notifier notifier() {
        return this.notifier;
    }

    @Override
    public boolean requestJournalDisabled() {
        return this.requestJournalDisabled;
    }

    @Override
    public String bindAddress() {
        return this.bindAddress;
    }

    @Override
    public List<CaseInsensitiveKey> matchingHeaders() {
        return this.matchingHeaders;
    }

    @Override
    public String proxyUrl() {
        return this.proxyUrl;
    }

    @Override
    public boolean shouldPreserveHostHeader() {
        return this.preserveHostHeader;
    }

    @Override
    public String proxyHostHeader() {
        return this.proxyHostHeader;
    }
}

