/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.servlet;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.LocalNotifier;
import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.core.FaultInjector;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.http.ChunkedDribbleDelay;
import com.github.tomakehurst.wiremock.http.Fault;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpResponder;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestHandler;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.http.Response;
import com.github.tomakehurst.wiremock.servlet.BodyChunker;
import com.github.tomakehurst.wiremock.servlet.FaultInjectorFactory;
import com.github.tomakehurst.wiremock.servlet.MultipartRequestConfigurer;
import com.github.tomakehurst.wiremock.servlet.NoFaultInjectorFactory;
import com.github.tomakehurst.wiremock.servlet.WireMockHttpServletRequestAdapter;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.servlet.AsyncContext;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import wiremock.com.google.common.base.Charsets;
import wiremock.com.google.common.io.ByteStreams;

public class WireMockHandlerDispatchingServlet
extends HttpServlet {
    public static final String SHOULD_FORWARD_TO_FILES_CONTEXT = "shouldForwardToFilesContext";
    public static final String ASYNCHRONOUS_RESPONSE_EXECUTOR = WireMockHandlerDispatchingServlet.class.getSimpleName() + ".asynchronousResponseExecutor";
    public static final String MAPPED_UNDER_KEY = "mappedUnder";
    private static final long serialVersionUID = -6602042274260495538L;
    private ScheduledExecutorService scheduledExecutorService;
    private RequestHandler requestHandler;
    private FaultInjectorFactory faultHandlerFactory;
    private String mappedUnder;
    private Notifier notifier;
    private String wiremockFileSourceRoot = "/";
    private boolean shouldForwardToFilesContext;
    private MultipartRequestConfigurer multipartRequestConfigurer;
    private Options.ChunkedEncodingPolicy chunkedEncodingPolicy;

    @Override
    public void init(ServletConfig config) {
        ServletContext context = config.getServletContext();
        this.shouldForwardToFilesContext = this.getFileContextForwardingFlagFrom(config);
        if (context.getInitParameter("WireMockFileSourceRoot") != null) {
            this.wiremockFileSourceRoot = context.getInitParameter("WireMockFileSourceRoot");
        }
        this.scheduledExecutorService = (ScheduledExecutorService)context.getAttribute(ASYNCHRONOUS_RESPONSE_EXECUTOR);
        String handlerClassName = config.getInitParameter("RequestHandlerClass");
        String faultInjectorFactoryClassName = config.getInitParameter("FaultHandlerFactoryClass");
        this.mappedUnder = this.getNormalizedMappedUnder(config);
        context.log("RequestHandlerClass from context returned " + handlerClassName + ". Normalized mapped under returned '" + this.mappedUnder + "'");
        this.requestHandler = (RequestHandler)context.getAttribute(handlerClassName);
        this.faultHandlerFactory = faultInjectorFactoryClassName != null ? (FaultInjectorFactory)context.getAttribute(faultInjectorFactoryClassName) : new NoFaultInjectorFactory();
        this.notifier = (Notifier)context.getAttribute("Notifier");
        this.multipartRequestConfigurer = (MultipartRequestConfigurer)context.getAttribute(MultipartRequestConfigurer.KEY);
        Object chunkedEncodingPolicyAttr = context.getAttribute(Options.ChunkedEncodingPolicy.class.getName());
        this.chunkedEncodingPolicy = chunkedEncodingPolicyAttr != null ? (Options.ChunkedEncodingPolicy)((Object)chunkedEncodingPolicyAttr) : Options.ChunkedEncodingPolicy.ALWAYS;
    }

    private String getNormalizedMappedUnder(ServletConfig config) {
        String mappedUnder = config.getInitParameter(MAPPED_UNDER_KEY);
        if (mappedUnder == null) {
            return null;
        }
        if (mappedUnder.endsWith("/")) {
            mappedUnder = mappedUnder.substring(0, mappedUnder.length() - 1);
        }
        return mappedUnder;
    }

    private boolean getFileContextForwardingFlagFrom(ServletConfig config) {
        String flagValue = config.getInitParameter(SHOULD_FORWARD_TO_FILES_CONTEXT);
        return Boolean.valueOf(flagValue);
    }

    @Override
    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        LocalNotifier.set(this.notifier);
        WireMockHttpServletRequestAdapter request = new WireMockHttpServletRequestAdapter(httpServletRequest, this.multipartRequestConfigurer, this.mappedUnder);
        ServletHttpResponder responder = new ServletHttpResponder(httpServletRequest, httpServletResponse);
        this.requestHandler.handle(request, responder);
    }

    public void applyResponse(Response response, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        Fault fault = response.getFault();
        if (fault != null) {
            FaultInjector faultInjector = this.buildFaultInjector(httpServletRequest, httpServletResponse);
            fault.apply(faultInjector);
            httpServletResponse.addHeader(Fault.class.getName(), fault.name());
            return;
        }
        if (response.getStatusMessage() == null) {
            httpServletResponse.setStatus(response.getStatus());
        } else {
            httpServletResponse.setStatus(response.getStatus(), response.getStatusMessage());
        }
        for (HttpHeader header : response.getHeaders().all()) {
            for (String value : header.values()) {
                httpServletResponse.addHeader(header.key(), value);
            }
        }
        if (this.chunkedEncodingPolicy == Options.ChunkedEncodingPolicy.NEVER || this.chunkedEncodingPolicy == Options.ChunkedEncodingPolicy.BODY_FILE && response.hasInlineBody()) {
            httpServletResponse.setContentLength(response.getBody().length);
        }
        if (response.shouldAddChunkedDribbleDelay()) {
            this.writeAndTranslateExceptionsWithChunkedDribbleDelay(httpServletResponse, response.getBodyStream(), response.getChunkedDribbleDelay());
        } else {
            WireMockHandlerDispatchingServlet.writeAndTranslateExceptions(httpServletResponse, response.getBodyStream());
        }
    }

    private FaultInjector buildFaultInjector(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return this.faultHandlerFactory.buildFaultInjector(httpServletRequest, httpServletResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeAndTranslateExceptions(HttpServletResponse httpServletResponse, InputStream content) {
        try (ServletOutputStream out = httpServletResponse.getOutputStream();){
            ByteStreams.copy(content, out);
            out.flush();
        }
        catch (IOException e) {
            Exceptions.throwUnchecked(e);
        }
        finally {
            try {
                content.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void writeAndTranslateExceptionsWithChunkedDribbleDelay(HttpServletResponse httpServletResponse, InputStream bodyStream, ChunkedDribbleDelay chunkedDribbleDelay) {
        try (ServletOutputStream out = httpServletResponse.getOutputStream();){
            byte[] body = ByteStreams.toByteArray(bodyStream);
            if (body.length < 1) {
                this.notifier.error("Cannot chunk dribble delay when no body set");
                out.flush();
                return;
            }
            byte[][] chunkedBody = BodyChunker.chunkBody(body, chunkedDribbleDelay.getNumberOfChunks());
            int chunkInterval = chunkedDribbleDelay.getTotalDuration() / chunkedBody.length;
            for (byte[] bodyChunk : chunkedBody) {
                Thread.sleep(chunkInterval);
                out.write(bodyChunk);
                out.flush();
            }
        }
        catch (IOException e) {
            Exceptions.throwUnchecked(e);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void forwardToFilesContext(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Request request) throws ServletException, IOException {
        String forwardUrl = this.wiremockFileSourceRoot + "__files" + request.getUrl();
        RequestDispatcher dispatcher = httpServletRequest.getRequestDispatcher(URLDecoder.decode(forwardUrl, Charsets.UTF_8.name()));
        dispatcher.forward(httpServletRequest, httpServletResponse);
    }

    private class ServletHttpResponder
    implements HttpResponder {
        private final HttpServletRequest httpServletRequest;
        private final HttpServletResponse httpServletResponse;

        public ServletHttpResponder(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
            this.httpServletRequest = httpServletRequest;
            this.httpServletResponse = httpServletResponse;
        }

        @Override
        public void respond(Request request, Response response) {
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            this.httpServletRequest.setAttribute("wiremock.ORIGINAL_REQUEST", LoggedRequest.createFrom(request));
            if (this.isAsyncSupported(response, this.httpServletRequest)) {
                this.respondAsync(request, response);
            } else {
                this.respondSync(request, response);
            }
        }

        private void respondSync(Request request, Response response) {
            this.delayIfRequired(response.getInitialDelay());
            this.respondTo(request, response);
        }

        private void delayIfRequired(long delayMillis) {
            try {
                TimeUnit.MILLISECONDS.sleep(delayMillis);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        private boolean isAsyncSupported(Response response, HttpServletRequest httpServletRequest) {
            return WireMockHandlerDispatchingServlet.this.scheduledExecutorService != null && response.getInitialDelay() > 0L && httpServletRequest.isAsyncSupported();
        }

        private void respondAsync(final Request request, final Response response) {
            final AsyncContext asyncContext = this.httpServletRequest.startAsync();
            WireMockHandlerDispatchingServlet.this.scheduledExecutorService.schedule(new Runnable(){

                @Override
                public void run() {
                    try {
                        ServletHttpResponder.this.respondTo(request, response);
                    }
                    finally {
                        asyncContext.complete();
                    }
                }
            }, response.getInitialDelay(), TimeUnit.MILLISECONDS);
        }

        private void respondTo(Request request, Response response) {
            try {
                if (response.wasConfigured()) {
                    WireMockHandlerDispatchingServlet.this.applyResponse(response, this.httpServletRequest, this.httpServletResponse);
                } else if (request.getMethod().equals(RequestMethod.GET) && WireMockHandlerDispatchingServlet.this.shouldForwardToFilesContext) {
                    WireMockHandlerDispatchingServlet.this.forwardToFilesContext(this.httpServletRequest, this.httpServletResponse, request);
                } else {
                    this.httpServletResponse.sendError(404);
                }
            }
            catch (Exception e) {
                Exceptions.throwUnchecked(e);
            }
        }
    }
}

