/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.parser;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.ArgumentDeclaration;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.MixinReference;
import com.github.sommeri.less4j.core.ast.ReusableStructure;
import com.github.sommeri.less4j.core.ast.Variable;
import com.github.sommeri.less4j.core.ast.VariableDeclaration;
import com.github.sommeri.less4j.core.parser.ASTBuilderSwitch;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.core.problems.ProblemsHandler;
import java.util.Iterator;
import java.util.List;

public class MixinsParametersBuilder {
    private final ASTBuilderSwitch parentBuilder;
    private ProblemsHandler problemsHandler;

    public MixinsParametersBuilder(ASTBuilderSwitch astBuilderSwitch, ProblemsHandler problemsHandler) {
        this.parentBuilder = astBuilderSwitch;
        this.problemsHandler = problemsHandler;
    }

    public void handleMixinReferenceArguments(HiddenTokenAwareTree token, MixinReference reference) {
        List<HiddenTokenAwareTree> children = token.getChildren();
        if (this.containsType(children, 78)) {
            this.handleSemicolonSplitMixinReferenceArguments(token, reference);
        } else {
            this.handleCommaSplitMixinReferenceArguments(token, reference);
        }
    }

    private void handleSemicolonSplitMixinReferenceArguments(HiddenTokenAwareTree token, MixinReference reference) {
        List<HiddenTokenAwareTree> children = token.getChildren();
        for (HiddenTokenAwareTree kid : children) {
            if (kid.getGeneralType() == 78) continue;
            ASTCssNode parameter = (ASTCssNode)this.parentBuilder.switchOn(kid);
            if (parameter.getType() == ASTCssNodeType.VARIABLE_DECLARATION) {
                reference.addNamedParameter((VariableDeclaration)parameter);
                continue;
            }
            reference.addPositionalParameter((Expression)parameter);
        }
    }

    private void handleCommaSplitMixinReferenceArguments(HiddenTokenAwareTree token, MixinReference reference) {
        List<HiddenTokenAwareTree> children = token.getChildren();
        for (HiddenTokenAwareTree kid : children) {
            ASTCssNode parameter = (ASTCssNode)this.parentBuilder.switchOn(kid);
            if (parameter.getType() == ASTCssNodeType.VARIABLE_DECLARATION) {
                VariableDeclaration variableDeclaration = (VariableDeclaration)parameter;
                Iterator<Expression> expressions = variableDeclaration.getValue().splitByComma().iterator();
                variableDeclaration.setValue(expressions.next());
                reference.addNamedParameter(variableDeclaration);
                this.addAsPositional(reference, expressions);
                continue;
            }
            Iterator<Expression> expressions = ((Expression)parameter).splitByComma().iterator();
            this.addAsPositional(reference, expressions);
        }
    }

    private void addAsPositional(MixinReference reference, Iterator<Expression> expressions) {
        while (expressions.hasNext()) {
            reference.addPositionalParameter(expressions.next());
        }
    }

    private boolean containsType(List<HiddenTokenAwareTree> list, int type) {
        for (HiddenTokenAwareTree element : list) {
            if (element.getGeneralType() != type) continue;
            return true;
        }
        return false;
    }

    public void handleMixinDeclarationArguments(HiddenTokenAwareTree token, ReusableStructure declaration) {
        List<HiddenTokenAwareTree> children = token.getChildren();
        if (this.containsType(children, 78)) {
            this.handleSemicolonSplitMixinDeclarationArguments(token, declaration);
        } else {
            this.handleCommaSplitMixinDeclarationArguments(token, declaration);
        }
    }

    private void handleCommaSplitMixinDeclarationArguments(HiddenTokenAwareTree token, ReusableStructure declaration) {
        List<HiddenTokenAwareTree> children = token.getChildren();
        for (HiddenTokenAwareTree kid : children) {
            if (kid.getGeneralType() == 78) continue;
            ASTCssNode argument = (ASTCssNode)this.parentBuilder.switchOn(kid);
            if (argument.getType() == ASTCssNodeType.ARGUMENT_DECLARATION) {
                ArgumentDeclaration argumentDeclaration = (ArgumentDeclaration)argument;
                this.addParameter(declaration, argumentDeclaration);
                if (argumentDeclaration.getValue() == null) continue;
                Iterator<Expression> expressions = argumentDeclaration.getValue().splitByComma().iterator();
                argumentDeclaration.setValue(expressions.next());
                this.addParameters(declaration, expressions);
                continue;
            }
            Iterator<Expression> expressions = ((Expression)argument).splitByComma().iterator();
            this.addParameters(declaration, expressions);
        }
    }

    private void addParameter(ReusableStructure declaration, ASTCssNode parameter) {
        declaration.addParameter(parameter);
    }

    private void addParameters(ReusableStructure declaration, Iterator<Expression> expressions) {
        while (expressions.hasNext()) {
            Expression next = expressions.next();
            if (next.getType() == ASTCssNodeType.VARIABLE) {
                this.addParameter(declaration, new ArgumentDeclaration((Variable)next, null));
                continue;
            }
            this.addParameter(declaration, next);
        }
    }

    private void handleSemicolonSplitMixinDeclarationArguments(HiddenTokenAwareTree token, ReusableStructure declaration) {
        List<HiddenTokenAwareTree> children = token.getChildren();
        for (HiddenTokenAwareTree kid : children) {
            if (kid.getGeneralType() == 78) continue;
            this.addParameter(declaration, (ASTCssNode)this.parentBuilder.switchOn(kid));
        }
    }
}

