/*
 * Decompiled with CFR 0.152.
 */
package shiver.me.timbers.retrying;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shiver.me.timbers.retrying.Choice;
import shiver.me.timbers.retrying.Chooser;
import shiver.me.timbers.retrying.Intervals;
import shiver.me.timbers.retrying.Options;
import shiver.me.timbers.retrying.RetryerService;
import shiver.me.timbers.retrying.Until;

public class Retryer
implements RetryerService {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private final Chooser choices;

    public Retryer() {
        this(new Options());
    }

    public Retryer(Options options) {
        this.choices = options.chooser();
    }

    @Override
    public <T> T retry(Until<T> until) throws Throwable {
        Choice choice = this.choices.choose();
        int retries = choice.getRetries();
        Thrower thrower = new Thrower(choice);
        Intervals intervals = choice.getIntervals();
        for (int i = 0; i < retries; ++i) {
            try {
                return until.success();
            }
            catch (Throwable e) {
                thrower.register(e);
                thrower.throwIfNotSuppressed();
                this.log.warn("Retry attempt ({}) for execution ({}) because of exception ({}, {}).", new Object[]{i + 1, until, e.getClass(), e.getMessage()});
                intervals.sleep();
                continue;
            }
        }
        return thrower.throwRegisteredThrowable();
    }

    private class Thrower {
        private final Choice choice;
        private Throwable throwable;

        Thrower(Choice choice) {
            this.choice = choice;
        }

        void register(Throwable throwable) {
            this.throwable = throwable;
        }

        void throwIfNotSuppressed() throws Throwable {
            if (!this.choice.isSuppressed(this.throwable)) {
                this.throwRegisteredThrowable();
            }
        }

        <T> T throwRegisteredThrowable() throws Throwable {
            throw this.throwable;
        }
    }
}

