/*
 * Decompiled with CFR 0.152.
 */
package shiver.me.timbers.retrying;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import shiver.me.timbers.retrying.Chooser;
import shiver.me.timbers.retrying.CompositeOverridingChooser;
import shiver.me.timbers.retrying.DefaultChoices;
import shiver.me.timbers.retrying.ManualChoices;
import shiver.me.timbers.retrying.OptionsManualChoices;
import shiver.me.timbers.retrying.OptionsService;
import shiver.me.timbers.retrying.PropertyChoices;
import shiver.me.timbers.retrying.StaticDefaultChoices;
import shiver.me.timbers.retrying.SystemPropertyChoices;
import shiver.me.timbers.retrying.Time;

public class Options
implements OptionsService {
    private final DefaultChoices defaultChoices;
    private final PropertyChoices propertyChoices;
    private final ManualChoices<Options> manualChoices;
    private Integer retries;
    private Time interval;
    private Set<Class<? extends Throwable>> includes;
    private Set<Class<? extends Throwable>> excludes;

    public Options() {
        this(new StaticDefaultChoices(), new SystemPropertyChoices(), new OptionsManualChoices());
    }

    Options(DefaultChoices defaultChoices, PropertyChoices propertyChoices, ManualChoices<Options> manualChoices) {
        this.defaultChoices = defaultChoices;
        this.propertyChoices = propertyChoices;
        this.manualChoices = manualChoices;
    }

    @Override
    public Options withRetries(Integer retries) {
        this.retries = retries;
        return this;
    }

    @Override
    public Options includes(Class<? extends Throwable> ... includes) {
        this.includes = new HashSet<Class<? extends Throwable>>(Arrays.asList(includes));
        return this;
    }

    @Override
    public Options excludes(Class<? extends Throwable> ... excludes) {
        this.excludes = new HashSet<Class<? extends Throwable>>(Arrays.asList(excludes));
        return this;
    }

    @Override
    public Options withIntervals(TimeUnit unit, Long ... durations) {
        this.interval = new Time(unit, durations);
        return this;
    }

    Chooser chooser() {
        return new CompositeOverridingChooser(this.defaultChoices, this.propertyChoices, this.manualChoices.apply(this));
    }

    Integer getRetries() {
        return this.retries;
    }

    Time getInterval() {
        return this.interval;
    }

    Set<Class<? extends Throwable>> getIncludes() {
        return this.includes;
    }

    public Set<Class<? extends Throwable>> getExcludes() {
        return this.excludes;
    }
}

