/*
 * Decompiled with CFR 0.152.
 */
package shiver.me.timbers.retrying;

import java.util.Set;
import shiver.me.timbers.retrying.Intervals;
import shiver.me.timbers.retrying.Time;

class Choice {
    private final int retries;
    private final Time interval;
    private final Set<Class<? extends Throwable>> includes;
    private final Set<Class<? extends Throwable>> excludes;

    Choice(int retries, Time interval, Set<Class<? extends Throwable>> includes, Set<Class<? extends Throwable>> excludes) {
        this.retries = Choice.validateRetries(retries);
        this.interval = interval;
        this.includes = includes;
        this.excludes = excludes;
    }

    private static int validateRetries(int retries) {
        if (retries > 0) {
            return retries;
        }
        throw new IllegalArgumentException(String.format("The retries value must be greater than 1. The value (%s) is invalid.", retries));
    }

    int getRetries() {
        return this.retries;
    }

    Intervals getIntervals() {
        return this.interval.startIntervals();
    }

    boolean isSuppressed(Throwable throwable) {
        if (this.includes.isEmpty() && this.excludes.isEmpty()) {
            return true;
        }
        Class<?> type = throwable.getClass();
        if (this.excludes.contains(type)) {
            return false;
        }
        return this.includes.contains(type) || this.includes.isEmpty();
    }
}

