/*
 * Decompiled with CFR 0.152.
 */
package shiver.me.timbers.retrying;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import shiver.me.timbers.retrying.AbstractOverridingChoices;
import shiver.me.timbers.retrying.PropertyChoices;
import shiver.me.timbers.retrying.Time;

abstract class AbstractPropertyChoices
extends AbstractOverridingChoices
implements PropertyChoices {
    AbstractPropertyChoices() {
    }

    @Override
    public Integer getRetries() {
        return AbstractPropertyChoices.toIntegerOrNull(this.getRetriesProperty());
    }

    @Override
    public Time getInterval() {
        Long[] duration = AbstractPropertyChoices.toLongsOrNull(this.getIntervalDurationProperty());
        TimeUnit unit = AbstractPropertyChoices.toTimeUnitOrNull(this.getIntervalUnitProperty());
        if (duration == null || unit == null) {
            return null;
        }
        return new Time(unit, duration);
    }

    @Override
    public Set<Class<? extends Throwable>> getIncludes() {
        return AbstractPropertyChoices.toThrowableClasses(this.getIncludesProperty());
    }

    @Override
    public Set<Class<? extends Throwable>> getExcludes() {
        return AbstractPropertyChoices.toThrowableClasses(this.getExcludesProperty());
    }

    abstract String getRetriesProperty();

    abstract String getIntervalDurationProperty();

    abstract String getIntervalUnitProperty();

    abstract String getIncludesProperty();

    abstract String getExcludesProperty();

    private static Integer toIntegerOrNull(String string) {
        return string == null ? null : Integer.valueOf(string);
    }

    private static Long[] toLongsOrNull(String string) {
        return string == null || string.isEmpty() ? null : AbstractPropertyChoices.toLongs(string);
    }

    private static Long[] toLongs(String string) {
        String[] strings = string.split(",");
        Long[] longs = new Long[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            longs[i] = Long.valueOf(strings[i]);
        }
        return longs;
    }

    private static TimeUnit toTimeUnitOrNull(String string) {
        return string == null || string.isEmpty() ? null : TimeUnit.valueOf(string);
    }

    private static Set<Class<? extends Throwable>> toThrowableClasses(String value) {
        return AbstractPropertyChoices.toClasses(value == null || value.isEmpty() ? new String[]{} : value.split(","));
    }

    private static Set<Class> toClasses(String[] split) {
        HashSet<Class> classes = new HashSet<Class>(split.length);
        for (String className : split) {
            try {
                classes.add(Class.forName(className));
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(String.format("Could not load the throwable class (%s).", className), e);
            }
        }
        return classes;
    }
}

