/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.template;

import com.power.common.util.CollectionUtil;
import com.power.common.util.StringUtil;
import com.power.doc.builder.ProjectDocConfigBuilder;
import com.power.doc.model.ApiConfig;
import com.power.doc.model.ApiDoc;
import com.power.doc.model.ApiGroup;
import com.power.doc.model.ApiMethodDoc;
import com.power.doc.model.annotation.FrameworkAnnotations;
import com.power.doc.utils.DocPathUtil;
import com.power.doc.utils.DocUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public interface IDocBuildTemplate<T> {
    public List<T> getApiData(ProjectDocConfigBuilder var1);

    public FrameworkAnnotations registeredAnnotations();

    default public List<ApiDoc> handleApiGroup(List<ApiDoc> apiDocList, ApiConfig apiConfig) {
        if (CollectionUtil.isEmpty(apiDocList) || apiConfig == null) {
            return apiDocList;
        }
        List<ApiGroup> groups = apiConfig.getGroups();
        ArrayList<ApiDoc> finalApiDocs = new ArrayList<ApiDoc>();
        ApiDoc defaultGroup = ApiDoc.buildGroupApiDoc("default");
        AtomicInteger order = new AtomicInteger(1);
        finalApiDocs.add(defaultGroup);
        if (CollectionUtil.isEmpty(groups)) {
            defaultGroup.setOrder(order.getAndIncrement());
            defaultGroup.getChildrenApiDocs().addAll(apiDocList);
            return finalApiDocs;
        }
        HashMap hasInsert = new HashMap();
        for (ApiGroup group2 : groups) {
            ApiDoc groupApiDoc = ApiDoc.buildGroupApiDoc(group2.getName());
            finalApiDocs.add(groupApiDoc);
            for (ApiDoc doc : apiDocList) {
                if (hasInsert.containsKey(doc.getAlias()) || !DocUtil.isMatch(group2.getApis(), doc.getPackageName() + "." + doc.getName())) continue;
                hasInsert.put(doc.getAlias(), null);
                groupApiDoc.getChildrenApiDocs().add(doc);
                doc.setOrder(groupApiDoc.getChildrenApiDocs().size());
                doc.setGroup(group2.getName());
                if (StringUtil.isEmpty((String)group2.getPaths())) continue;
                List<ApiMethodDoc> methodDocs = doc.getList().stream().filter(l -> DocPathUtil.matches(l.getPath(), group2.getPaths(), null)).collect(Collectors.toList());
                doc.setList(methodDocs);
            }
        }
        for (ApiDoc doc : apiDocList) {
            String key = doc.getAlias();
            if (hasInsert.containsKey(key)) continue;
            defaultGroup.getChildrenApiDocs().add(doc);
            doc.setOrder(defaultGroup.getChildrenApiDocs().size());
            hasInsert.put(doc.getAlias(), null);
        }
        if (CollectionUtil.isEmpty(defaultGroup.getChildrenApiDocs())) {
            finalApiDocs.remove(defaultGroup);
        }
        finalApiDocs.forEach(group -> group.setOrder(order.getAndIncrement()));
        return finalApiDocs;
    }
}

