/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.helper;

import com.power.common.util.CollectionUtil;
import com.power.common.util.StringUtil;
import com.power.doc.builder.ProjectDocConfigBuilder;
import com.power.doc.model.ApiParam;
import com.power.doc.model.CustomRespField;
import com.power.doc.utils.DocClassUtil;
import com.power.doc.utils.DocUtil;
import com.power.doc.utils.JavaClassUtil;
import com.power.doc.utils.JavaClassValidateUtil;
import com.power.doc.utils.JavaFieldUtil;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class ParamsBuildHelper {
    public static List<ApiParam> buildParams(String className, String pre, int i, String isRequired, Map<String, CustomRespField> responseFieldMap, boolean isResp, Map<String, String> registryClasses, ProjectDocConfigBuilder projectBuilder) {
        if (StringUtil.isEmpty((String)className)) {
            throw new RuntimeException("Class name can't be null or empty.");
        }
        ArrayList<ApiParam> paramList = new ArrayList<ApiParam>();
        if (registryClasses.containsKey(className) && i > registryClasses.size()) {
            return paramList;
        }
        registryClasses.put(className, className);
        String simpleName = DocClassUtil.getSimpleName(className);
        String[] globGicName = DocClassUtil.getSimpleGicName(className);
        JavaClass cls = projectBuilder.getClassByName(simpleName);
        List<JavaField> fields = JavaClassUtil.getFields(cls, 0);
        int n = 0;
        if (JavaClassValidateUtil.isPrimitive(simpleName)) {
            paramList.addAll(ParamsBuildHelper.primitiveReturnRespComment(DocClassUtil.processTypeNameForParams(simpleName)));
        } else if (JavaClassValidateUtil.isCollection(simpleName) || JavaClassValidateUtil.isArray(simpleName)) {
            if (!JavaClassValidateUtil.isCollection(globGicName[0])) {
                String gicName = globGicName[0];
                if (JavaClassValidateUtil.isArray(gicName)) {
                    gicName = gicName.substring(0, gicName.indexOf("["));
                }
                paramList.addAll(ParamsBuildHelper.buildParams(gicName, pre, i + 1, isRequired, responseFieldMap, isResp, registryClasses, projectBuilder));
            }
        } else if (JavaClassValidateUtil.isMap(simpleName)) {
            if (globGicName.length == 2) {
                paramList.addAll(ParamsBuildHelper.buildParams(globGicName[1], pre, i + 1, isRequired, responseFieldMap, isResp, registryClasses, projectBuilder));
            }
        } else if ("java.lang.Object".equals(className)) {
            ApiParam param = ApiParam.of().setField(pre + "any object").setType("object");
            if (StringUtil.isEmpty((String)isRequired)) {
                param.setDesc("any object.").setVersion("-");
            } else {
                param.setDesc("any object.").setRequired(false).setVersion("-");
            }
            paramList.add(param);
        } else {
            boolean isGenerics = JavaFieldUtil.checkGenerics(fields);
            block0: for (JavaField field : fields) {
                String gName;
                ApiParam param;
                CustomRespField customResponseField;
                String comment;
                String fieldName = field.getName();
                String subTypeName = field.getType().getFullyQualifiedName();
                if (field.isStatic() || "this$0".equals(fieldName) || JavaClassValidateUtil.isIgnoreFieldTypes(subTypeName)) continue;
                String typeSimpleName = field.getType().getSimpleName();
                String fieldGicName = field.getType().getGenericCanonicalName();
                List javaAnnotations = field.getAnnotations();
                Map<String, String> tagsMap = DocUtil.getFieldTagsValue(field);
                String since = "-";
                if (!isResp) {
                    if (tagsMap.containsKey("ignore")) continue;
                    if (tagsMap.containsKey("since")) {
                        since = tagsMap.get("since");
                    }
                } else if (tagsMap.containsKey("since")) {
                    since = tagsMap.get("since");
                }
                boolean strRequired = false;
                int annotationCounter = 0;
                for (JavaAnnotation annotation : javaAnnotations) {
                    String annotationName = annotation.getType().getSimpleName();
                    if ("JsonIgnore".equals(annotationName) && isResp) continue block0;
                    if ("JSONField".equals(annotationName) && isResp) {
                        if (null != annotation.getProperty("serialize")) {
                            if (!Boolean.FALSE.toString().equals(annotation.getProperty("serialize").toString())) continue;
                            continue block0;
                        }
                        if (null == annotation.getProperty("name")) continue;
                        fieldName = StringUtil.removeQuotes((String)annotation.getProperty("name").toString());
                        continue;
                    }
                    if ("JsonProperty".equals(annotationName) && isResp) {
                        if (null == annotation.getProperty("value")) continue;
                        fieldName = StringUtil.removeQuotes((String)annotation.getProperty("value").toString());
                        continue;
                    }
                    if (!JavaClassValidateUtil.isJSR303Required(annotationName)) continue;
                    strRequired = true;
                    ++annotationCounter;
                    break;
                }
                if (annotationCounter < 1 && tagsMap.containsKey("required")) {
                    strRequired = true;
                }
                if (StringUtil.isNotEmpty((String)(comment = null != (customResponseField = responseFieldMap.get(field.getName())) && StringUtil.isNotEmpty((String)customResponseField.getDesc()) ? customResponseField.getDesc() : field.getComment()))) {
                    comment = DocUtil.replaceNewLineToHtmlBr(comment);
                }
                if (JavaClassValidateUtil.isPrimitive(subTypeName)) {
                    param = ApiParam.of().setField(pre + fieldName);
                    String processedType = DocClassUtil.processTypeNameForParams(typeSimpleName.toLowerCase());
                    param.setType(processedType);
                    if (StringUtil.isNotEmpty((String)comment)) {
                        ParamsBuildHelper.commonHandleParam(paramList, param, isRequired, comment, since, strRequired);
                        continue;
                    }
                    ParamsBuildHelper.commonHandleParam(paramList, param, isRequired, "No comments found.", since, strRequired);
                    continue;
                }
                param = ApiParam.of().setField(pre + fieldName);
                JavaClass javaClass = projectBuilder.getJavaProjectBuilder().getClassByName(subTypeName);
                String enumComments = javaClass.getComment();
                if (StringUtil.isNotEmpty((String)enumComments) && javaClass.isEnum()) {
                    enumComments = DocUtil.replaceNewLineToHtmlBr(enumComments);
                    comment = comment + "(See: " + enumComments + ")";
                }
                String processedType = DocClassUtil.processTypeNameForParams(typeSimpleName.toLowerCase());
                param.setType(processedType);
                if (!isResp && javaClass.isEnum()) {
                    List methods = javaClass.getMethods();
                    int index = 0;
                    String reTypeName = "string";
                    block2: for (JavaMethod method : methods) {
                        JavaType type = method.getReturnType();
                        reTypeName = type.getCanonicalName();
                        List javaAnnotationList = method.getAnnotations();
                        for (JavaAnnotation annotation : javaAnnotationList) {
                            if (!annotation.getType().getSimpleName().contains("JsonValue")) continue;
                            break block2;
                        }
                        if (CollectionUtil.isEmpty((Collection)javaAnnotations) && index < 1) break;
                        ++index;
                    }
                    param.setType(DocClassUtil.processTypeNameForParams(reTypeName));
                }
                if (StringUtil.isNotEmpty((String)comment)) {
                    ParamsBuildHelper.commonHandleParam(paramList, param, isRequired, comment, since, strRequired);
                } else {
                    ParamsBuildHelper.commonHandleParam(paramList, param, isRequired, "No comments found.", since, strRequired);
                }
                StringBuilder preBuilder = new StringBuilder();
                for (int j = 0; j < i; ++j) {
                    preBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
                }
                preBuilder.append("\u2514\u2500");
                if (JavaClassValidateUtil.isMap(subTypeName)) {
                    String gNameTemp = field.getType().getGenericCanonicalName();
                    if (JavaClassValidateUtil.isMap(gNameTemp)) {
                        ApiParam param1 = ApiParam.of().setField(preBuilder.toString() + "any object").setType("object").setDesc("any object.").setVersion("-");
                        paramList.add(param1);
                        continue;
                    }
                    String valType = DocClassUtil.getMapKeyValueType(gNameTemp)[1];
                    if (JavaClassValidateUtil.isPrimitive(valType)) continue;
                    if (valType.length() == 1) {
                        String gicName = n < globGicName.length ? globGicName[n] : globGicName[globGicName.length - 1];
                        if (JavaClassValidateUtil.isPrimitive(gicName) || simpleName.equals(gicName)) continue;
                        paramList.addAll(ParamsBuildHelper.buildParams(gicName, preBuilder.toString(), i + 1, isRequired, responseFieldMap, isResp, registryClasses, projectBuilder));
                        continue;
                    }
                    paramList.addAll(ParamsBuildHelper.buildParams(valType, preBuilder.toString(), i + 1, isRequired, responseFieldMap, isResp, registryClasses, projectBuilder));
                    continue;
                }
                if (JavaClassValidateUtil.isCollection(subTypeName)) {
                    String[] gNameArr;
                    String gNameTemp = field.getType().getGenericCanonicalName();
                    if (globGicName.length > 0 && "java.util.List".equals(gNameTemp)) {
                        gNameTemp = gNameTemp + "<T>";
                    }
                    if ((gNameArr = DocClassUtil.getSimpleGicName(gNameTemp)).length == 0 || JavaClassValidateUtil.isPrimitive(gName = DocClassUtil.getSimpleGicName(gNameTemp)[0]) || simpleName.equals(gName) || gName.equals(simpleName)) continue;
                    if (gName.length() == 1) {
                        String gicName;
                        int len = globGicName.length;
                        if (len <= 0 || JavaClassValidateUtil.isPrimitive(gicName = n < len ? globGicName[n] : globGicName[len - 1]) || simpleName.equals(gicName)) continue;
                        paramList.addAll(ParamsBuildHelper.buildParams(gicName, preBuilder.toString(), i + 1, isRequired, responseFieldMap, isResp, registryClasses, projectBuilder));
                        continue;
                    }
                    paramList.addAll(ParamsBuildHelper.buildParams(gName, preBuilder.toString(), i + 1, isRequired, responseFieldMap, isResp, registryClasses, projectBuilder));
                    continue;
                }
                if (subTypeName.length() == 1 || "java.lang.Object".equals(subTypeName)) {
                    if (isGenerics && "java.lang.Object".equals(subTypeName)) {
                        ApiParam param1 = ApiParam.of().setField(preBuilder.toString() + "any object").setType("object").setDesc("any object.").setVersion("-");
                        paramList.add(param1);
                        continue;
                    }
                    if (simpleName.equals(className)) continue;
                    if (n < globGicName.length) {
                        String gicName = globGicName[n];
                        String simple = DocClassUtil.getSimpleName(gicName);
                        if (!JavaClassValidateUtil.isPrimitive(simple)) {
                            if (gicName.contains("<")) {
                                if (JavaClassValidateUtil.isCollection(simple)) {
                                    gName = DocClassUtil.getSimpleGicName(gicName)[0];
                                    if (!JavaClassValidateUtil.isPrimitive(gName)) {
                                        paramList.addAll(ParamsBuildHelper.buildParams(gName, preBuilder.toString(), i + 1, isRequired, responseFieldMap, isResp, registryClasses, projectBuilder));
                                    }
                                } else if (JavaClassValidateUtil.isMap(simple)) {
                                    String valType = DocClassUtil.getMapKeyValueType(gicName)[1];
                                    if (!JavaClassValidateUtil.isPrimitive(valType)) {
                                        paramList.addAll(ParamsBuildHelper.buildParams(valType, preBuilder.toString(), i + 1, isRequired, responseFieldMap, isResp, registryClasses, projectBuilder));
                                    }
                                } else {
                                    paramList.addAll(ParamsBuildHelper.buildParams(gicName, preBuilder.toString(), i + 1, isRequired, responseFieldMap, isResp, registryClasses, projectBuilder));
                                }
                            } else {
                                paramList.addAll(ParamsBuildHelper.buildParams(gicName, preBuilder.toString(), i + 1, isRequired, responseFieldMap, isResp, registryClasses, projectBuilder));
                            }
                        }
                    } else {
                        paramList.addAll(ParamsBuildHelper.buildParams(subTypeName, preBuilder.toString(), i + 1, isRequired, responseFieldMap, isResp, registryClasses, projectBuilder));
                    }
                    ++n;
                    continue;
                }
                if (JavaClassValidateUtil.isArray(subTypeName)) {
                    if (className.equals(fieldGicName = fieldGicName.substring(0, fieldGicName.indexOf("["))) || JavaClassValidateUtil.isPrimitive(fieldGicName)) continue;
                    paramList.addAll(ParamsBuildHelper.buildParams(fieldGicName, preBuilder.toString(), i + 1, isRequired, responseFieldMap, isResp, registryClasses, projectBuilder));
                    continue;
                }
                if (simpleName.equals(subTypeName) || javaClass.isEnum()) continue;
                paramList.addAll(ParamsBuildHelper.buildParams(fieldGicName, preBuilder.toString(), i + 1, isRequired, responseFieldMap, isResp, registryClasses, projectBuilder));
            }
        }
        return paramList;
    }

    public static List<ApiParam> primitiveReturnRespComment(String typeName) {
        StringBuilder comments = new StringBuilder();
        comments.append("The api directly returns the ").append(typeName).append(" type value.");
        ApiParam apiParam = ApiParam.of().setField("No field").setType(typeName).setDesc(comments.toString()).setVersion("-");
        ArrayList<ApiParam> paramList = new ArrayList<ApiParam>();
        paramList.add(apiParam);
        return paramList;
    }

    private static void commonHandleParam(List<ApiParam> paramList, ApiParam param, String isRequired, String comment, String since, boolean strRequired) {
        if (StringUtil.isEmpty((String)isRequired)) {
            param.setDesc(comment).setVersion(since);
            paramList.add(param);
        } else {
            param.setDesc(comment).setVersion(since).setRequired(strRequired);
            paramList.add(param);
        }
    }
}

