/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.handler;

import com.power.common.util.StringUtil;
import com.power.doc.model.ApiReqHeader;
import com.power.doc.utils.DocClassUtil;
import com.power.doc.utils.DocUtil;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SpringMVCRequestHeaderHandler {
    public List<ApiReqHeader> handle(JavaMethod method) {
        ArrayList<ApiReqHeader> apiReqHeaders = new ArrayList<ApiReqHeader>();
        block0: for (JavaParameter javaParameter : method.getParameters()) {
            List javaAnnotations = javaParameter.getAnnotations();
            String className = method.getDeclaringClass().getCanonicalName();
            Map<String, String> paramMap = DocUtil.getParamsComments(method, "param", className);
            String paramName = javaParameter.getName();
            for (JavaAnnotation annotation : javaAnnotations) {
                String annotationName = annotation.getType().getName();
                if (!"RequestHeader".equals(annotationName)) continue;
                ApiReqHeader apiReqHeader = new ApiReqHeader();
                Map requestHeaderMap = annotation.getNamedParameterMap();
                if (requestHeaderMap.get("value") != null) {
                    apiReqHeader.setName(StringUtil.removeQuotes((String)((String)requestHeaderMap.get("value"))));
                } else {
                    apiReqHeader.setName(paramName);
                }
                StringBuilder desc = new StringBuilder();
                String comments = paramMap.get(paramName);
                desc.append(comments);
                if (requestHeaderMap.get("defaultValue") != null) {
                    desc.append("(defaultValue: ").append(StringUtil.removeQuotes((String)((String)requestHeaderMap.get("defaultValue")))).append(")");
                }
                apiReqHeader.setDesc(desc.toString());
                if (requestHeaderMap.get("required") != null) {
                    apiReqHeader.setRequired(!Boolean.FALSE.toString().equals(requestHeaderMap.get("required")));
                } else {
                    apiReqHeader.setRequired(true);
                }
                String typeName = javaParameter.getType().getValue().toLowerCase();
                apiReqHeader.setType(DocClassUtil.processTypeNameForParams(typeName));
                apiReqHeaders.add(apiReqHeader);
                continue block0;
            }
        }
        return apiReqHeaders;
    }
}

