/*
 * Decompiled with CFR 0.152.
 */
package com.pengrad.telegrambot.request;

import com.pengrad.telegrambot.model.request.InputMedia;
import com.pengrad.telegrambot.request.BaseRequest;
import com.pengrad.telegrambot.response.MessagesResponse;
import java.util.Map;

public class SendMediaGroup
extends BaseRequest<SendMediaGroup, MessagesResponse> {
    private boolean isMultipart = false;

    public SendMediaGroup(Object chatId, InputMedia<?> ... media) {
        super(MessagesResponse.class);
        ((SendMediaGroup)this.add("chat_id", chatId)).add("media", media);
        for (InputMedia<?> m : media) {
            Map<String, Object> attachments = m.getAttachments();
            if (attachments != null && attachments.size() > 0) {
                this.addAll(attachments);
                this.isMultipart = true;
            }
            if (m.inputFile() == null) continue;
            this.add(m.getInputFileId(), m.inputFile());
            this.isMultipart = true;
        }
    }

    public SendMediaGroup messageThreadId(Integer messageThreadId) {
        return (SendMediaGroup)this.add("message_thread_id", messageThreadId);
    }

    public SendMediaGroup disableNotification(boolean disableNotification) {
        return (SendMediaGroup)this.add("disable_notification", disableNotification);
    }

    public SendMediaGroup replyToMessageId(int replyToMessageId) {
        return (SendMediaGroup)this.add("reply_to_message_id", replyToMessageId);
    }

    public SendMediaGroup allowSendingWithoutReply(boolean allowSendingWithoutReply) {
        return (SendMediaGroup)this.add("allow_sending_without_reply", allowSendingWithoutReply);
    }

    @Override
    public boolean isMultipart() {
        return this.isMultipart;
    }
}

