/*
 * Decompiled with CFR 0.152.
 */
package com.pengrad.telegrambot.model;

import com.pengrad.telegrambot.model.ChatLocation;
import com.pengrad.telegrambot.model.ChatPermissions;
import com.pengrad.telegrambot.model.ChatPhoto;
import com.pengrad.telegrambot.model.Message;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;

public class Chat
implements Serializable {
    private static final long serialVersionUID = 0L;
    private Long id;
    private Type type;
    private String title;
    private String username;
    private String first_name;
    private String last_name;
    private Boolean is_forum;
    private ChatPhoto photo;
    private String[] active_usernames;
    private String emoji_status_custom_emoji_id;
    private String bio;
    private Boolean has_private_forwards;
    private Boolean has_restricted_voice_and_video_messages;
    private Boolean has_hidden_members;
    private Boolean has_aggressive_anti_spam_enabled;
    private Boolean join_to_send_messages;
    private Boolean join_by_request;
    private String description;
    private String invite_link;
    private Message pinned_message;
    private ChatPermissions permissions;
    private Integer slow_mode_delay;
    private Integer message_auto_delete_time;
    private Boolean has_protected_content;
    private String sticker_set_name;
    private Boolean can_set_sticker_set;
    private Long linked_chat_id;
    private ChatLocation location;

    public Long id() {
        return this.id;
    }

    public Type type() {
        return this.type;
    }

    public String firstName() {
        return this.first_name;
    }

    public String lastName() {
        return this.last_name;
    }

    public String username() {
        return this.username;
    }

    public Boolean isForum() {
        return this.is_forum != null && this.is_forum != false;
    }

    public String title() {
        return this.title;
    }

    public ChatPhoto photo() {
        return this.photo;
    }

    public String[] getActiveUsernames() {
        return this.active_usernames;
    }

    public String getEmojiStatusCustomEmojiId() {
        return this.emoji_status_custom_emoji_id;
    }

    public String bio() {
        return this.bio;
    }

    public Boolean hasPrivateForwards() {
        return this.has_private_forwards != null && this.has_private_forwards != false;
    }

    public Boolean hasRestrictedVoiceAndVideoMessages() {
        return this.has_restricted_voice_and_video_messages != null && this.has_restricted_voice_and_video_messages != false;
    }

    public Boolean hasHiddenMembers() {
        return this.has_hidden_members != null && this.has_hidden_members != false;
    }

    public Boolean hasAggressiveAntiSpamEnabled() {
        return this.has_aggressive_anti_spam_enabled != null && this.has_aggressive_anti_spam_enabled != false;
    }

    public Boolean joinToSendMessages() {
        return this.join_to_send_messages != null && this.join_to_send_messages != false;
    }

    public Boolean joinByRequest() {
        return this.join_by_request != null && this.join_by_request != false;
    }

    public String description() {
        return this.description;
    }

    public String inviteLink() {
        return this.invite_link;
    }

    public Message pinnedMessage() {
        return this.pinned_message;
    }

    public ChatPermissions permissions() {
        return this.permissions;
    }

    public Integer slowModeDelay() {
        return this.slow_mode_delay;
    }

    public Integer messageAutoDeleteTime() {
        return this.message_auto_delete_time;
    }

    public Boolean hasProtectedContent() {
        return this.has_protected_content != null && this.has_protected_content != false;
    }

    public String stickerSetName() {
        return this.sticker_set_name;
    }

    public Boolean canSetStickerSet() {
        return this.can_set_sticker_set != null && this.can_set_sticker_set != false;
    }

    public Long linkedChatId() {
        return this.linked_chat_id;
    }

    public ChatLocation location() {
        return this.location;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Chat chat = (Chat)o;
        return Objects.equals(this.id, chat.id) && this.type == chat.type && Objects.equals(this.first_name, chat.first_name) && Objects.equals(this.last_name, chat.last_name) && Objects.equals(this.is_forum, chat.is_forum) && Objects.equals(this.username, chat.username) && Objects.equals(this.title, chat.title) && Objects.equals(this.photo, chat.photo) && Arrays.equals(this.active_usernames, chat.active_usernames) && Objects.equals(this.emoji_status_custom_emoji_id, chat.emoji_status_custom_emoji_id) && Objects.equals(this.bio, chat.bio) && Objects.equals(this.has_private_forwards, chat.has_private_forwards) && Objects.equals(this.has_restricted_voice_and_video_messages, chat.has_restricted_voice_and_video_messages) && Objects.equals(this.has_hidden_members, chat.has_hidden_members) && Objects.equals(this.has_aggressive_anti_spam_enabled, chat.has_aggressive_anti_spam_enabled) && Objects.equals(this.join_to_send_messages, chat.join_to_send_messages) && Objects.equals(this.join_by_request, chat.join_by_request) && Objects.equals(this.description, chat.description) && Objects.equals(this.invite_link, chat.invite_link) && Objects.equals(this.pinned_message, chat.pinned_message) && Objects.equals(this.permissions, chat.permissions) && Objects.equals(this.slow_mode_delay, chat.slow_mode_delay) && Objects.equals(this.message_auto_delete_time, chat.message_auto_delete_time) && Objects.equals(this.has_protected_content, chat.has_protected_content) && Objects.equals(this.sticker_set_name, chat.sticker_set_name) && Objects.equals(this.can_set_sticker_set, chat.can_set_sticker_set) && Objects.equals(this.linked_chat_id, chat.linked_chat_id) && Objects.equals(this.location, chat.location);
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public String toString() {
        return "Chat{id=" + this.id + ", type=" + (Object)((Object)this.type) + ", first_name='" + this.first_name + '\'' + ", last_name='" + this.last_name + '\'' + ", is_forum=" + this.is_forum + ", username='" + this.username + '\'' + ", title='" + this.title + '\'' + ", photo=" + this.photo + ", active_usernames=" + Arrays.toString(this.active_usernames) + ", emoji_status_custom_emoji_id='" + this.emoji_status_custom_emoji_id + '\'' + ", bio='" + this.bio + '\'' + ", has_private_forwards=" + this.has_private_forwards + ", has_restricted_voice_and_video_messages=" + this.has_restricted_voice_and_video_messages + ", has_hidden_members=" + this.has_hidden_members + ", has_aggressive_anti_spam_enabled=" + this.has_aggressive_anti_spam_enabled + ", join_to_send_messages=" + this.join_to_send_messages + ", join_by_request=" + this.join_by_request + ", description='" + this.description + '\'' + ", invite_link='" + this.invite_link + '\'' + ", pinned_message=" + this.pinned_message + ", permissions=" + this.permissions + ", slow_mode_delay=" + this.slow_mode_delay + ", message_auto_delete_time=" + this.message_auto_delete_time + ", has_protected_content=" + this.has_protected_content + ", sticker_set_name='" + this.sticker_set_name + '\'' + ", can_set_sticker_set=" + this.can_set_sticker_set + ", linked_chat_id=" + this.linked_chat_id + ", location=" + this.location + '}';
    }

    public static enum Type {
        Private,
        group,
        supergroup,
        channel;

    }
}

