/*
 * Decompiled with CFR 0.152.
 */
package com.github.oscerd.component.cassandra;

import com.datastax.driver.core.ResultSet;
import com.github.oscerd.component.cassandra.IResultSetFormatStrategy;
import java.util.ArrayList;
import java.util.Iterator;

public class ResultSetFormatStrategies {
    private static final IResultSetFormatStrategy rowsList = new IResultSetFormatStrategy(){

        @Override
        public Object getResult(ResultSet resultSet) {
            ArrayList rows = new ArrayList();
            Iterator rowIter = resultSet.iterator();
            while (rowIter.hasNext()) {
                rows.add(rowIter.next());
            }
            return rows;
        }
    };
    private static final IResultSetFormatStrategy normalResultSet = new IResultSetFormatStrategy(){

        @Override
        public Object getResult(ResultSet resultSet) {
            return resultSet;
        }
    };

    public static IResultSetFormatStrategy rowsList() {
        return rowsList;
    }

    public static IResultSetFormatStrategy normalResultSet() {
        return normalResultSet;
    }

    public static IResultSetFormatStrategy fromName(String name) {
        if (name.equals("normalResultSet")) {
            return ResultSetFormatStrategies.normalResultSet();
        }
        if (name.equals("rowsList")) {
            return ResultSetFormatStrategies.rowsList();
        }
        return null;
    }
}

